/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Damage;
import gurpsinittool.data.DiceAdds;
import gurpsinittool.util.MiscUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DamageExpression {
    private static final Logger LOG = Logger.getLogger(DamageExpression.class.getName());
    private boolean addBasicThrust = false;
    private boolean addBasicSwing = false;
    private DiceAdds diceAdds = new DiceAdds();
    private Double divisor = 1.0;
    private DamageType type = DamageType.cr;
    private boolean explosive = false;

    private DamageExpression() {
    }

    private DamageExpression(DamageExpression copy) {
        this.addBasicSwing = copy.addBasicSwing;
        this.addBasicThrust = copy.addBasicThrust;
        this.diceAdds.dice = copy.diceAdds.dice;
        this.diceAdds.adds = copy.diceAdds.adds;
        this.divisor = copy.divisor;
        this.type = copy.type;
        this.explosive = copy.explosive;
    }

    public Damage getDamage(Actor attacker) throws ParseException {
        DamageExpression simplified = this.convertBasicDamage(attacker);
        return new Damage(simplified.diceAdds.roll(), simplified.divisor, simplified.type, simplified.explosive);
    }

    public String toString() {
        String output;
        String diceAddString;
        ArrayList<String> elements = new ArrayList<String>();
        if (this.addBasicThrust) {
            elements.add("thr");
        }
        if (this.addBasicSwing) {
            elements.add("sw");
        }
        if (!(diceAddString = this.diceAdds.toString()).isEmpty()) {
            elements.add(diceAddString);
        }
        if ((output = String.join((CharSequence)"+", elements)).isEmpty()) {
            output = "0";
        }
        if (this.divisor != 1.0) {
            output = String.valueOf(output) + "(" + MiscUtil.formatDoubleNicely(this.divisor) + ")";
        }
        output = String.valueOf(output) + " " + DamageExpression.damageTypeToString(this.type);
        if (this.explosive) {
            output = String.valueOf(output) + " ex";
        }
        return output;
    }

    public DamageExpression convertBasicDamage(Actor attacker) throws ParseException {
        DamageExpression simplified = new DamageExpression(this);
        if (this.addBasicThrust || this.addBasicSwing) {
            if (attacker == null) {
                ParseException ex = new ParseException("Can't simplify expression with thr/sw and null attacker!", 0);
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, ex.getMessage(), ex);
                }
                throw ex;
            }
            try {
                if (this.addBasicThrust) {
                    simplified.addBasicThrust = false;
                    String thrustString = attacker.getTraitValue(ActorBase.CalculatedTrait.BasicThrust.toString());
                    DamageExpression thrust = DamageExpression.parseDamageExpression(thrustString);
                    simplified.diceAdds.add(thrust.diceAdds);
                }
                if (this.addBasicSwing) {
                    simplified.addBasicSwing = false;
                    String swingString = attacker.getTraitValue(ActorBase.CalculatedTrait.BasicSwing.toString());
                    DamageExpression swing = DamageExpression.parseDamageExpression(swingString);
                    simplified.diceAdds.add(swing.diceAdds);
                }
            }
            catch (ParseException ex) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Unexpected parser error while evaluating basic damage! " + ex.getMessage(), ex);
                }
                throw ex;
            }
            simplified.diceAdds.simplify();
        }
        return simplified;
    }

    public static DamageExpression parseDamageExpression(String damageExpression) throws ParseException {
        Matcher matcher;
        if (damageExpression.isEmpty()) {
            return new DamageExpression();
        }
        Pattern thrsw = Pattern.compile("^(thr|sw)");
        Pattern dice = Pattern.compile("^(\\d+)d");
        Pattern adds = Pattern.compile("^(\\d+)");
        Pattern more = Pattern.compile("^\\s*(\\+|-)\\s*");
        Pattern divisor = Pattern.compile("^\\s*\\((\\d+\\.?\\d*|\\.\\d+)\\)\\s*");
        Pattern type = Pattern.compile("^\\s*([^d\\d\\s]+)\\s*");
        Pattern explosive = Pattern.compile("^\\s*ex\\s*");
        StringBuilder line = new StringBuilder(damageExpression);
        DamageExpression parsedExpression = new DamageExpression();
        parsedExpression.type = DamageType.cut;
        int multiplier = 1;
        while (true) {
            String value;
            if ((matcher = thrsw.matcher(line)).lookingAt()) {
                if (multiplier == -1) {
                    throw new ParseException("parseDamageExpression: Parsing '" + damageExpression + "': can't have -thr or -sw", 0);
                }
                value = matcher.group(1);
                if ("thr".equals(value)) {
                    if (parsedExpression.addBasicThrust) {
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.info("Damage expression has multiple 'thr' strings!");
                        }
                        throw new ParseException("parseDamageExpression: Parsing '" + damageExpression + "': more than one 'thr'!", 0);
                    }
                    parsedExpression.addBasicThrust = true;
                } else {
                    if (parsedExpression.addBasicSwing) {
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.info("Damage expression has multiple 'sw' strings!");
                        }
                        throw new ParseException("parseDamageExpression: Parsing '" + damageExpression + "': more than one 'sw'!", 0);
                    }
                    parsedExpression.addBasicSwing = true;
                }
            } else {
                matcher = dice.matcher(line);
                if (matcher.lookingAt()) {
                    parsedExpression.diceAdds.dice += Integer.valueOf(matcher.group(1)) * multiplier;
                } else {
                    matcher = adds.matcher(line);
                    if (matcher.lookingAt()) {
                        parsedExpression.diceAdds.adds += Integer.valueOf(matcher.group(1)) * multiplier;
                    } else {
                        throw new ParseException("parseDamageExpression: Parsing '" + damageExpression + "': unexpected end of first section!", 0);
                    }
                }
            }
            line.delete(0, matcher.end());
            matcher = more.matcher(line);
            if (!matcher.lookingAt()) break;
            value = matcher.group(1);
            multiplier = "+".equals(value) ? 1 : -1;
            line.delete(0, matcher.end());
        }
        matcher = divisor.matcher(line);
        if (matcher.lookingAt()) {
            parsedExpression.divisor = Double.valueOf(matcher.group(1));
            line.delete(0, matcher.end());
        }
        if ((matcher = type.matcher(line)).lookingAt()) {
            parsedExpression.type = DamageExpression.parseType(matcher.group(1));
            line.delete(0, matcher.end());
        }
        if ((matcher = explosive.matcher(line)).lookingAt()) {
            parsedExpression.explosive = true;
            line.delete(0, matcher.end());
        }
        if (line.length() != 0) {
            throw new ParseException("parseDamageExpression: Parsing '" + damageExpression + "': text left over! '" + line + "'", 0);
        }
        return parsedExpression;
    }

    public static DamageType parseType(String type) throws ParseException {
        type = type.replace('-', '_');
        type = type.replace('+', '4');
        try {
            return DamageType.valueOf(type);
        }
        catch (Exception e) {
            throw new ParseException("ParseType: Unable to parse string: " + type, 0);
        }
    }

    public static String damageTypeToString(DamageType type) {
        String output = type.toString();
        output = output.replace('_', '-');
        output = output.replace('4', '+');
        return output;
    }

    public static enum DamageType {
        aff,
        burn,
        cor,
        cr,
        cut,
        fat,
        imp,
        pi_,
        pi,
        pi4,
        pi44,
        spec,
        tbb,
        tox;

    }
}

