/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.DR;
import gurpsinittool.data.Damage;
import gurpsinittool.data.HitLocations;
import gurpsinittool.data.traits.InjuryTolerance;
import gurpsinittool.data.traits.SupernaturalDurability;
import gurpsinittool.data.traits.Vulnerability;
import gurpsinittool.util.DieRoller;
import java.util.logging.Logger;

public class Defense {
    private static final Logger LOG = Logger.getLogger(Defense.class.getName());
    public DefenseType type;
    public boolean ee = false;
    public boolean retreat = false;
    public boolean side = false;
    public boolean stunned = false;
    public boolean shield = false;
    public String position = "";
    public int otherMod = 0;
    public int roll;
    public DR overrideDR;
    public Damage damage;
    public HitLocations.HitLocation location;
    public int effectiveDefense;
    public DefenseResult result;
    public int fatigue;
    public int injury;
    public int shieldDamage;
    public boolean majorWound;
    public boolean cripplingInjury;

    public void setInitialOptions(Actor actor) {
        int effParry = actor.getCurrentDefenseValue(DefenseType.Parry);
        int effBlock = actor.getCurrentDefenseValue(DefenseType.Block);
        int effDodge = actor.getCurrentDefenseValue(DefenseType.Dodge);
        int shieldDB = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DB);
        int shieldHP = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_HP);
        this.type = effParry > effDodge && effParry >= effBlock ? DefenseType.Parry : (effBlock > effDodge && effBlock > effParry ? DefenseType.Block : DefenseType.Dodge);
        boolean bl = this.shield = shieldDB > 0 && actor.getTempInt("shieldDamage") < shieldHP;
        if (actor.isStunned() || actor.hasStatus(ActorBase.ActorStatus.Disabled)) {
            this.stunned = true;
        }
        if (actor.hasStatus(ActorBase.ActorStatus.Kneeling)) {
            this.position = "Kneeling";
        }
        if (actor.hasStatus(ActorBase.ActorStatus.Prone)) {
            this.position = "Prone";
        }
    }

    public void calcDefenseResults(Actor actor) {
        this.calcEffectiveDefense(actor);
        this.calcDefenseResult(actor);
        this.location = InjuryTolerance.getAdjustedLocation(actor, this.location);
        this.determineImpact(actor);
    }

    private void calcEffectiveDefense(Actor actor) {
        this.effectiveDefense = actor.getCurrentDefenseValue(this.type);
        if (this.type != DefenseType.None) {
            if (this.ee) {
                this.effectiveDefense += 2;
                this.fatigue = 1;
            } else {
                this.fatigue = 0;
            }
            if (this.retreat) {
                this.effectiveDefense += this.type == DefenseType.Dodge ? 3 : 1;
            }
            if (this.side) {
                this.effectiveDefense -= 2;
            }
            if (this.stunned) {
                this.effectiveDefense -= 4;
            }
            if (this.shield) {
                this.effectiveDefense += actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DB);
            }
            if ("Kneeling".equals(this.position)) {
                this.effectiveDefense -= 2;
            }
            if ("Prone".equals(this.position)) {
                this.effectiveDefense -= 3;
            }
            this.effectiveDefense += this.otherMod;
        }
    }

    private void calcDefenseResult(Actor actor) {
        int shieldDB;
        int n = shieldDB = this.shield ? actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DB) : 0;
        this.result = this.type == DefenseType.None ? DefenseResult.Failure : (DieRoller.isCritSuccess(this.roll, this.effectiveDefense) ? DefenseResult.CritSuccess : (DieRoller.isCritFailure(this.roll, this.effectiveDefense) ? DefenseResult.CritFailure : (DieRoller.isFailure(this.roll, this.effectiveDefense) ? DefenseResult.Failure : (DieRoller.isFailure(this.roll, this.effectiveDefense - shieldDB) ? DefenseResult.ShieldHit : DefenseResult.Success))));
    }

    private void determineImpact(Actor actor) {
        int coverEffDR = 0;
        this.injury = 0;
        this.shieldDamage = 0;
        this.majorWound = false;
        this.cripplingInjury = false;
        int shieldDR = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DR);
        int shieldHP = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_HP);
        int hitPoints = actor.getTraitValueInt(ActorBase.BasicTrait.HP);
        switch (this.result) {
            case CritSuccess: 
            case Success: {
                return;
            }
            case ShieldHit: {
                int shieldBasicDamage = (int)((double)this.damage.basicDamage - Math.floor((double)shieldDR / this.damage.armorDivisor));
                shieldBasicDamage = Math.min((int)Math.ceil(shieldHP / 4), shieldBasicDamage);
                shieldBasicDamage = Math.max(0, shieldBasicDamage);
                this.shieldDamage = (int)Math.floor((double)shieldBasicDamage * InjuryTolerance.woundingModifierHomogenous(this.damage.type));
                this.shieldDamage = this.shieldDamage <= 0 && shieldBasicDamage > 0 ? 1 : this.shieldDamage;
                coverEffDR = (int)Math.floor(((double)shieldDR + Math.ceil(shieldHP / 4)) / this.damage.armorDivisor);
            }
            case Failure: 
            case CritFailure: {
                int armorEffDR = this.overrideDR.getDRforDamage(this.damage);
                int locationEffDR = this.location.extraDR.getDRforDamage(this.damage);
                int penetratingDamage = this.damage.basicDamage - coverEffDR - armorEffDR - locationEffDR;
                penetratingDamage = Math.max(0, penetratingDamage);
                this.calculateInjury(actor, penetratingDamage);
                if (this.location.cripplingThreshold != 0.0) {
                    int cripplingThreshold = (int)Math.floor((double)hitPoints * this.location.cripplingThreshold + 1.00001);
                    if (this.injury < cripplingThreshold) break;
                    this.injury = cripplingThreshold;
                    this.cripplingInjury = SupernaturalDurability.canCripple(actor);
                    this.majorWound = true;
                    break;
                }
                int majorWoundThreshold = (int)Math.floor((double)(hitPoints * 1 / 2) + 1.00001);
                if (this.injury < majorWoundThreshold) break;
                this.majorWound = true;
            }
        }
    }

    private void calculateInjury(Actor actor, int penetratingDamage) {
        Double calcInjury = penetratingDamage;
        calcInjury = calcInjury * (double)Vulnerability.getVulnerabilityMultiplier(actor, this.damage.type);
        calcInjury = calcInjury * this.getWoundingModifier(actor);
        calcInjury = calcInjury / InjuryTolerance.getDamageReduction(actor);
        this.injury = (calcInjury = Double.valueOf(Math.min(calcInjury, (double)InjuryTolerance.getInjuryLimit(actor, this.damage)))) <= 1.0 && penetratingDamage > 0 ? 1 : calcInjury.intValue();
    }

    private double getWoundingModifier(Actor actor) {
        Double woundingModifier = this.location.getWoundingModifier(this.damage.type);
        return InjuryTolerance.getWoundingModifier(actor, this.damage.type, woundingModifier);
    }

    public static enum DefenseResult {
        CritSuccess,
        Success,
        ShieldHit,
        Failure,
        CritFailure;

    }

    public static enum DefenseType {
        Parry,
        Block,
        Dodge,
        None;

    }
}

