/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.ui.ActorDetailsPanel_v2;
import gurpsinittool.ui.DefenseDialog;
import gurpsinittool.util.AbstractGAction;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogListener;
import gurpsinittool.util.EncounterLogSupport;
import gurpsinittool.util.MiscUtil;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class GameMaster
implements EncounterLogListener,
UndoableEditListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(GameMaster.class.getName());
    private Integer round = 0;
    private Integer activeActor = -1;
    private boolean gameLogicEnabled;
    private PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    private EncounterLogSupport mEls = new EncounterLogSupport(this);
    private UndoManager undoManager = new UndoManager();
    private Deque<CompoundEdit> compoundEdits = new LinkedList<CompoundEdit>();
    public InitTable initTable;
    public ActorDetailsPanel_v2 detailsPanel;
    public DefenseDialog defenseDialog;
    public Action actionUndo;
    public Action actionRedo;
    public Action actionNextActor;
    public Action actionEndRound;
    public Action actionNextRound;
    public Action actionResetRound;
    public Action actionTagActors;
    public Action actionAttack;
    public Action actionDefend;
    public Action actionPostureStanding;
    public Action actionPostureKneeling;
    public Action actionPostureProne;
    public Action actionStatusTogglePhysicalStun;
    public Action actionStatusToggleMentalStun;
    public Action actionStatusToggleRecoveringStun;
    public Action actionStatusToggleAttacking;
    public Action actionStatusToggleDisarmed;
    public Action actionStatusToggleUnconscious;
    public Action actionStatusToggleDead;
    public Action actionCoordinateSelectedStatusPhysicalStun;
    public Action actionCoordinateSelectedStatusMentalStun;
    public Action actionCoordinateSelectedStatusRecoveringStun;
    public Action actionCoordinateSelectedStatusAttacking;
    public Action actionCoordinateSelectedStatusDisarmed;
    public Action actionCoordinateSelectedStatusUnconscious;
    public Action actionCoordinateSelectedStatusDead;
    public Action actionCoordinateSelectedStatusWaiting;
    public Action actionCoordinateSelectedStatusDisabled;
    public Action actionSetSelectedTypePC;
    public Action actionSetSelectedTypeAlly;
    public Action actionSetSelectedTypeNeutral;
    public Action actionSetSelectedTypeEnemy;
    public Action actionSetSelectedTypeSpecial;
    public Action actionDeleteSelectedActors;
    public Action actionResetSelectedActors;
    public Action actionSetSelectedActorActive;
    public Action actionTagSelectedActors;
    public Action actionRemoveTagSelectedActors;
    private static Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
    private static int flagMaxNum = 6;

    public GameMaster(boolean enableGameLogic) {
        this.gameLogicEnabled = enableGameLogic;
        this.initializeActions();
        this.updateUndoRedo();
        this.addPropertyChangeListener(this);
    }

    public boolean isGameLogicEnabled() {
        return this.gameLogicEnabled;
    }

    public int getActiveActor() {
        return this.activeActor;
    }

    public int getRound() {
        return this.round;
    }

    private void selectActiveActor() {
        if (this.activeActor != -1) {
            this.initTable.setRowSelectionInterval(this.activeActor, this.activeActor);
        } else {
            this.initTable.clearSelection();
        }
    }

    private void setActiveActor(int newValue) {
        int oldValue = this.activeActor;
        this.activeActor = newValue;
        this.mPcs.firePropertyChange("ActiveActor", oldValue, newValue);
    }

    private void setRound(int newValue) {
        int oldValue = this.round;
        this.round = newValue;
        this.mPcs.firePropertyChange("Round", oldValue, newValue);
    }

    public void addActor(Actor actor, int position) {
        this.startCompoundEdit();
        if (position <= this.activeActor) {
            this.setActiveActor(this.activeActor + 1);
        }
        this.initTable.getActorTableModel().addActor(actor, position);
        this.endCompoundEdit("Add");
    }

    public void removeActor(int row) {
        this.startCompoundEdit();
        if (row == this.activeActor) {
            this.nextActor();
        }
        this.initTable.getActorTableModel().removeActor(row);
        if (row < this.activeActor) {
            this.setActiveActor(this.activeActor - 1);
        }
        this.endCompoundEdit("Remove");
    }

    public void removeActor(Actor actor) {
        int[] rows = this.initTable.getActorTableModel().getActorRows(actor);
        int i = rows.length - 1;
        while (i >= 0) {
            this.removeActor(rows[i]);
            --i;
        }
    }

    private boolean nextActor() {
        Actor currentActor;
        if (this.activeActor == -1) {
            this.setRound(this.round + 1);
            this.logEvent("<b>** Round " + this.round + " **</b>");
        }
        boolean retval = false;
        int actorRow = this.activeActor;
        do {
            if (this.activeActor == -1) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No previous active actor.");
                }
            } else {
                currentActor = this.initTable.getActorTableModel().getActor(actorRow);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Displacing active actor '" + currentActor.getTraitValue(ActorBase.BasicTrait.Name) + "'");
                }
                currentActor.loosingActive();
            }
            if (++actorRow >= this.initTable.getActorTableModel().getRowCount() - 1) {
                actorRow = -1;
                retval = true;
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.fine("End of round, no actor is currently active");
                break;
            }
            currentActor = this.initTable.getActorTableModel().getActor(actorRow);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("New active actor: '" + currentActor.getTraitValue(ActorBase.BasicTrait.Name) + "'");
            }
            currentActor.startTurnActive();
        } while (currentActor.hasStatus(ActorBase.ActorStatus.Disabled) || currentActor.hasStatus(ActorBase.ActorStatus.Unconscious) || currentActor.hasStatus(ActorBase.ActorStatus.Dead) || currentActor.hasStatus(ActorBase.ActorStatus.Waiting));
        this.setActiveActor(actorRow);
        return retval;
    }

    protected void nextRound() {
        if (this.activeActor != -1) {
            this.endRound();
        }
        this.nextActor();
    }

    protected void endRound() {
        while (!this.nextActor()) {
        }
    }

    private void flushInteractiveEdits() {
        this.detailsPanel.flushEdits();
        this.initTable.stopCellEditing();
    }

    private void coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus status) {
        Actor a;
        Actor[] actors;
        this.flushInteractiveEdits();
        this.startCompoundEdit();
        boolean allSet = true;
        Actor[] actorArray = actors = this.initTable.getSelectedActors();
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            a = actorArray[n2];
            if (!a.hasStatus(status)) {
                allSet = false;
                break;
            }
            ++n2;
        }
        actorArray = actors;
        n = actors.length;
        n2 = 0;
        while (n2 < n) {
            a = actorArray[n2];
            if (allSet) {
                a.removeStatus(status);
            } else {
                a.addStatus(status);
            }
            ++n2;
        }
        this.endCompoundEdit("Status");
    }

    private void toggleStatusOfSelectedActors(ActorBase.ActorStatus status) {
        this.flushInteractiveEdits();
        this.startCompoundEdit();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            if (a.hasStatus(status)) {
                a.removeStatus(status);
            } else {
                a.addStatus(status);
            }
            ++n2;
        }
        this.endCompoundEdit("Status");
    }

    private void modifyStatusOfSelectedActors(ActorBase.ActorStatus status, boolean add) {
        this.flushInteractiveEdits();
        this.startCompoundEdit();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            if (add) {
                a.addStatus(status);
            } else {
                a.removeStatus(status);
            }
            ++n2;
        }
        this.endCompoundEdit("Status");
    }

    private void setSelectedType(ActorBase.ActorType t) {
        this.flushInteractiveEdits();
        this.startCompoundEdit();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            a.setType(t);
            ++n2;
        }
        this.endCompoundEdit("Type");
    }

    private static String getNextTag(HashSet<String> tags) {
        flagColors[] flagColorsArray = flagColors.values();
        int n = flagColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            flagColors color = flagColorsArray[n2];
            int i = 1;
            while (i <= flagMaxNum) {
                String tag = String.valueOf(color.toString()) + i;
                if (!tags.contains(tag)) {
                    return tag;
                }
                ++i;
            }
            ++n2;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("No free tags!");
        }
        return "S99";
    }

    private void autoTagActors() {
        HashSet<String> tags = this.catalogTags(true);
        int i = 0;
        while (i < this.initTable.getActorTableModel().getRowCount() - 1) {
            Actor a = this.initTable.getActorTableModel().getActor(i);
            if (!(!a.isTypeAutomated() || a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead) || a.hasStatus(ActorBase.ActorStatus.Waiting))) {
                this.tagActor(a, tags);
            }
            ++i;
        }
    }

    private void removeTag(Actor actor) {
        String aName;
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        Matcher matcher = nameTag.matcher(aName = actor.getTraitValue(ActorBase.BasicTrait.Name));
        if (matcher.matches()) {
            String name = matcher.group(1);
            actor.setTrait(ActorBase.BasicTrait.Name, name);
        }
    }

    private void tagActor(Actor actor) {
        this.tagActor(actor, this.catalogTags(false));
    }

    private void tagActor(Actor actor, HashSet<String> tags) {
        String aName = actor.getTraitValue(ActorBase.BasicTrait.Name);
        if (!nameTag.matcher(aName).matches()) {
            String tag = GameMaster.getNextTag(tags);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Tagging actor " + aName + " with " + "[" + tag + "]");
            }
            actor.setTrait(ActorBase.BasicTrait.Name, String.valueOf(aName) + " [" + tag + "]");
            tags.add(tag);
        }
    }

    private HashSet<String> catalogTags(boolean clean) {
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        HashSet<String> tags = new HashSet<String>();
        int i = 0;
        while (i < this.initTable.getActorTableModel().getRowCount() - 1) {
            Matcher matcher;
            Actor a = this.initTable.getActorTableModel().getActor(i);
            String aName = a.getTraitValue(ActorBase.BasicTrait.Name);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Cataloging actor: " + aName);
            }
            if ((matcher = nameTag.matcher(aName)).matches()) {
                String name = matcher.group(1);
                String tag = matcher.group(2);
                if (clean && a.isTypeAutomated() && (a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead))) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Cleaning tag: " + tag);
                    }
                    a.setTrait(ActorBase.BasicTrait.Name, name);
                } else {
                    if (tags.contains(tag) && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Duplicate tag detected! " + tag);
                    }
                    tags.add(tag);
                }
            }
            ++i;
        }
        return tags;
    }

    private void initializeActions() {
        this.actionUndo = new AbstractGAction("Undo", "Undo the most recent edit (Ctrl+Z)", 85, new ImageIcon(GITApp.class.getResource("/resources/images/arrow_undo.png"), "Undo")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                block4: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Undo triggered");
                    }
                    GameMaster.this.flushInteractiveEdits();
                    if (GameMaster.this.getCompoundLevel() > 0 && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Undo action: triggered while compound edit being built!");
                    }
                    try {
                        GameMaster.this.undoManager.undo();
                    }
                    catch (CannotUndoException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block4;
                        LOG.log(Level.WARNING, "Cannot undo: " + e, e);
                    }
                }
                GameMaster.this.updateUndoRedo();
            }
        };
        this.actionRedo = new AbstractGAction("Redo", "Redo the most recent undo (Ctrl+Y)", 82, new ImageIcon(GITApp.class.getResource("/resources/images/arrow_redo.png"), "Redo")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                block4: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Redo triggered");
                    }
                    if (GameMaster.this.getCompoundLevel() > 0 && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Redo action: triggered while compound edit being built!");
                    }
                    try {
                        GameMaster.this.undoManager.redo();
                    }
                    catch (CannotRedoException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block4;
                        LOG.log(Level.WARNING, "Cannot redo: " + e, e);
                    }
                }
                GameMaster.this.updateUndoRedo();
            }
        };
        this.actionNextActor = new AbstractGAction("Next Combatant", "Move to the next active combatant in the turn sequence (Ctrl+N)", new ImageIcon(GITApp.class.getResource("/resources/images/control_play_blue.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.startCompoundEdit();
                GameMaster.this.nextActor();
                GameMaster.this.selectActiveActor();
                GameMaster.this.endCompoundEdit("Advance");
            }
        };
        this.actionEndRound = new AbstractGAction("End Round", "Step to the end of the turn sequence (Ctrl+E)", new ImageIcon(GITApp.class.getResource("/resources/images/control_end_blue.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.startCompoundEdit();
                GameMaster.this.endRound();
                GameMaster.this.selectActiveActor();
                GameMaster.this.endCompoundEdit("Advance");
            }
        };
        this.actionNextRound = new AbstractGAction("Next Round", "Step to the start of the next round sequence (Ctrl+R)", new ImageIcon(GITApp.class.getResource("/resources/images/control_fastforward_blue.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.startCompoundEdit();
                GameMaster.this.nextRound();
                GameMaster.this.selectActiveActor();
                GameMaster.this.endCompoundEdit("Advance");
            }
        };
        this.actionResetRound = new AbstractGAction("Reset Round Counter", "Reset the round counter (Alt+R)", new ImageIcon(GITApp.class.getResource("/resources/images/control_start_blue.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.startCompoundEdit();
                GameMaster.this.setRound(0);
                GameMaster.this.setActiveActor(-1);
                GameMaster.this.endCompoundEdit("Reset");
            }
        };
        this.actionDeleteSelectedActors = new AbstractGAction("Delete", "Delete the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                int result = JOptionPane.showConfirmDialog(GameMaster.this.initTable, "Are you sure you want to delete these rows?", "Confirm Row Delete", 2);
                GameMaster.this.startCompoundEdit();
                if (result == 0) {
                    int[] rows = GameMaster.this.initTable.getSelectedRows();
                    int i = rows.length - 1;
                    while (i >= 0) {
                        GameMaster.this.removeActor(rows[i]);
                        --i;
                    }
                }
                GameMaster.this.endCompoundEdit("Delete");
            }
        };
        this.actionResetSelectedActors = new AbstractGAction("Reset", "Reset the state of the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    a.reset();
                    ++n2;
                }
                GameMaster.this.endCompoundEdit("Reset");
            }
        };
        this.actionSetSelectedActorActive = new AbstractGAction("Set Active", "Set the selected combatant to be currently active", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                int[] rows = GameMaster.this.initTable.getSelectedRows();
                GameMaster.this.setActiveActor(rows[0]);
                GameMaster.this.initTable.getActorTableModel().getActor(GameMaster.this.activeActor).removeStatus(ActorBase.ActorStatus.Waiting);
                GameMaster.this.endCompoundEdit("Set Act");
            }
        };
        this.actionTagActors = new AbstractGAction("Update Tags", "Update all NPC tags (Ctrl+T)", new ImageIcon(GITApp.class.getResource("/resources/images/tag_blue_add.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                GameMaster.this.autoTagActors();
                GameMaster.this.endCompoundEdit("Tag");
                GameMaster.this.initTable.autoSizeColumns();
            }
        };
        this.actionTagSelectedActors = new AbstractGAction("Tag", "Add tags to the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    GameMaster.this.tagActor(a);
                    ++n2;
                }
                GameMaster.this.endCompoundEdit("Tag");
            }
        };
        this.actionRemoveTagSelectedActors = new AbstractGAction("Remove Tag", "Remove tags from the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    GameMaster.this.removeTag(a);
                    ++n2;
                }
                GameMaster.this.endCompoundEdit("Tag");
            }
        };
        this.actionAttack = new AbstractGAction("Attack", "Selected combatants attack (Ctrl+K)", new ImageIcon(GITApp.class.getResource("/resources/images/sword.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    a.attack();
                    ++n2;
                }
                GameMaster.this.endCompoundEdit("Attack");
            }
        };
        this.actionDefend = new AbstractGAction("Defend", "Selected combatant defends (Ctrl+D)", new ImageIcon(GITApp.class.getResource("/resources/images/shield.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Actor[] selected = GameMaster.this.initTable.getSelectedActors();
                if (selected.length == 0) {
                    return;
                }
                Actor actor = selected[0];
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.defenseDialog.setActor(actor);
                MiscUtil.validateOnScreen(GameMaster.this.defenseDialog);
                GameMaster.this.defenseDialog.setVisible(true);
                if (GameMaster.this.defenseDialog.valid) {
                    actor.defend(GameMaster.this.defenseDialog.defense);
                }
            }
        };
        this.actionPostureStanding = new AbstractGAction("Standing", "Set posture to standing", new ImageIcon(GITApp.class.getResource("/resources/images/arrow_up.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
                GameMaster.this.endCompoundEdit("Posture");
            }
        };
        this.actionPostureKneeling = new AbstractGAction("Kneeling", "Set posture to kneeling", new ImageIcon(GITApp.class.getResource("/resources/images/arrow_down_right.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, true);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
                GameMaster.this.endCompoundEdit("Posture");
            }
        };
        this.actionPostureProne = new AbstractGAction("Prone", "Set posture to prone", new ImageIcon(GITApp.class.getResource("/resources/images/arrow_down.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.flushInteractiveEdits();
                GameMaster.this.startCompoundEdit();
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, true);
                GameMaster.this.endCompoundEdit("Posture");
            }
        };
        this.actionStatusTogglePhysicalStun = new AbstractGAction("Physical Stun", "Toggle Status: Physically Stunned", new ImageIcon(GITApp.class.getResource("/resources/images/stun_phys.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunPhys);
            }
        };
        this.actionStatusToggleMentalStun = new AbstractGAction("Mental Stun", "Toggle Status: Mentally Stunned", new ImageIcon(GITApp.class.getResource("/resources/images/stun_mental.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunMental);
            }
        };
        this.actionStatusToggleRecoveringStun = new AbstractGAction("Recovering from Stun", "Toggle Status: Recovering from Stun", new ImageIcon(GITApp.class.getResource("/resources/images/stun_recover.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunRecovr);
            }
        };
        this.actionStatusToggleAttacking = new AbstractGAction("Attacking", "Toggle Status: Attacking", new ImageIcon(GITApp.class.getResource("/resources/images/sword_rotate.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Attacking);
            }
        };
        this.actionStatusToggleDisarmed = new AbstractGAction("Disarmed", "Toggle Status: Disarmed", new ImageIcon(GITApp.class.getResource("/resources/images/plus_blue.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Disarmed);
            }
        };
        this.actionStatusToggleUnconscious = new AbstractGAction("Unconscious", "Toggle Status: Unconscious", new ImageIcon(GITApp.class.getResource("/resources/images/cross_yellow.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Unconscious);
            }
        };
        this.actionStatusToggleDead = new AbstractGAction("Dead", "Toggle Status: Dead", new ImageIcon(GITApp.class.getResource("/resources/images/cross.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Dead);
            }
        };
        this.actionCoordinateSelectedStatusAttacking = new AbstractGAction("Attacking", "Change selected combatants' Attacking status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Attacking);
            }
        };
        this.actionCoordinateSelectedStatusDead = new AbstractGAction("Dead", "Change selected combatants' Dead status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Dead);
            }
        };
        this.actionCoordinateSelectedStatusDisabled = new AbstractGAction("Disabled", "Change selected combatants' Disabled status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Disabled);
            }
        };
        this.actionCoordinateSelectedStatusDisarmed = new AbstractGAction("Disarmed", "Change selected combatants' Disarmed status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Disarmed);
            }
        };
        this.actionCoordinateSelectedStatusUnconscious = new AbstractGAction("Unconscious", "Change selected combatants' Unconscious status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Unconscious);
            }
        };
        this.actionCoordinateSelectedStatusWaiting = new AbstractGAction("Waiting", "Change selected combatants' Waiting status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Waiting);
            }
        };
        this.actionCoordinateSelectedStatusMentalStun = new AbstractGAction("Mental Stun", "Change selected combatants' Mental Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunMental);
            }
        };
        this.actionCoordinateSelectedStatusPhysicalStun = new AbstractGAction("Physical Stun", "Change selected combatants' Physical Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunPhys);
            }
        };
        this.actionCoordinateSelectedStatusRecoveringStun = new AbstractGAction("Recovering Stun", "Change selected combatants' Recovering Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunRecovr);
            }
        };
        this.actionSetSelectedTypePC = new AbstractGAction("PC", "Set type to PC", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.PC);
            }
        };
        this.actionSetSelectedTypeAlly = new AbstractGAction("Ally", "Set type to Ally", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Ally);
            }
        };
        this.actionSetSelectedTypeNeutral = new AbstractGAction("Neutral", "Set type to Neutral", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Neutral);
            }
        };
        this.actionSetSelectedTypeEnemy = new AbstractGAction("Enemy", "Set type to Enemy", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Enemy);
            }
        };
        this.actionSetSelectedTypeSpecial = new AbstractGAction("Special", "Set type to Special", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Special);
            }
        };
    }

    public void addEncounterLogEventListener(EncounterLogListener listener) {
        this.mEls.addEncounterLogEventListener(listener);
    }

    public void removeEncounterLogEventListener(EncounterLogListener listener) {
        this.mEls.removeEncounterLogEventListener(listener);
    }

    private void logEvent(String text) {
        this.mEls.fireEncounterLogEvent(text);
    }

    @Override
    public void encounterLogMessageSent(EncounterLogEvent evt) {
        if (this.round <= 0) {
            return;
        }
        this.mEls.fireEncounterLogEvent(evt);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    private void updateUndoRedo() {
        this.actionUndo.setEnabled(this.undoManager.canUndo());
        this.actionRedo.setEnabled(this.undoManager.canRedo());
        if (this.undoManager.canUndo()) {
            this.actionUndo.putValue("Name", this.undoManager.getUndoPresentationName());
        } else {
            this.actionUndo.putValue("Name", "Undo");
        }
        if (this.undoManager.canRedo()) {
            this.actionRedo.putValue("Name", this.undoManager.getRedoPresentationName());
        } else {
            this.actionRedo.putValue("Name", "Redo");
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (ActorBase.HackStartCompound.class.isInstance(e.getEdit())) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Got a StartCompound edit");
            }
            this.startCompoundEdit();
        } else if (ActorBase.HackEndCompound.class.isInstance(e.getEdit())) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Got a EndCompound edit");
            }
            this.endCompoundEdit(e.getEdit().getPresentationName());
        } else {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Got a normal edit: " + e);
            }
            this.postUndoableEdit(e.getEdit());
        }
    }

    private void postUndoableEdit(UndoableEdit e) {
        if (this.getCompoundLevel() > 0) {
            this.compoundEdits.getLast().addEdit(e);
        } else {
            this.undoManager.addEdit(e);
        }
        this.updateUndoRedo();
    }

    private int getCompoundLevel() {
        return this.compoundEdits.size();
    }

    public void startCompoundEdit() {
        this.compoundEdits.push(new CompoundEdit());
    }

    public void endCompoundEdit(String display) {
        if (this.getCompoundLevel() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Compound edit not started!", new Exception());
            }
            return;
        }
        CompoundEdit edit = this.compoundEdits.pop();
        if (edit.isSignificant()) {
            edit.addEdit(new DisplayEdit(display));
            edit.end();
            this.postUndoableEdit(edit);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (GameMaster.class.isInstance(e.getSource())) {
            String propertyName;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Saw property change for Gamemaster");
            }
            if ((propertyName = e.getPropertyName()).equals("ActiveActor")) {
                this.postUndoableEdit(new ActiveActorEdit((Integer)e.getOldValue(), (Integer)e.getNewValue()));
            } else if (propertyName.equals("Round")) {
                this.postUndoableEdit(new RoundEdit((Integer)e.getOldValue(), (Integer)e.getNewValue()));
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Unrecognized GameMaster property: " + propertyName);
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unexpected source type: " + e.getSource().getClass().toString());
        }
    }

    public class ActionSetDefaultAttack
    extends AbstractAction {
        int num;

        public ActionSetDefaultAttack(int num) {
            this.num = num;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GameMaster.this.flushInteractiveEdits();
            Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
            int n = actorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Actor a = actorArray[n2];
                a.setDefaultAttack(this.num);
                ++n2;
            }
        }
    }

    private class ActiveActorEdit
    extends AbstractUndoableEdit {
        private int newValue;
        private int oldValue;

        public ActiveActorEdit(int oldValue, int newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Advance";
        }

        @Override
        public void undo() {
            super.undo();
            GameMaster.this.removePropertyChangeListener(GameMaster.this);
            GameMaster.this.setActiveActor(this.oldValue);
            GameMaster.this.addPropertyChangeListener(GameMaster.this);
        }

        @Override
        public void redo() {
            super.redo();
            GameMaster.this.removePropertyChangeListener(GameMaster.this);
            GameMaster.this.setActiveActor(this.newValue);
            GameMaster.this.addPropertyChangeListener(GameMaster.this);
        }
    }

    public class AttackNumAction
    extends AbstractAction {
        int num;

        public AttackNumAction(int num) {
            this.num = num;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GameMaster.this.flushInteractiveEdits();
            Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
            int n = actorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Actor a = actorArray[n2];
                a.attack(this.num);
                ++n2;
            }
        }
    }

    private class DisplayEdit
    extends AbstractUndoableEdit {
        String presentationName;

        public DisplayEdit(String presentationName) {
            this.presentationName = presentationName;
        }

        @Override
        public String getPresentationName() {
            return this.presentationName;
        }
    }

    private class RoundEdit
    extends AbstractUndoableEdit {
        private int newValue;
        private int oldValue;

        public RoundEdit(int oldValue, int newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Advance";
        }

        @Override
        public void undo() {
            super.undo();
            GameMaster.this.removePropertyChangeListener(GameMaster.this);
            GameMaster.this.setRound(this.oldValue);
            GameMaster.this.addPropertyChangeListener(GameMaster.this);
        }

        @Override
        public void redo() {
            super.redo();
            GameMaster.this.removePropertyChangeListener(GameMaster.this);
            GameMaster.this.setRound(this.newValue);
            GameMaster.this.addPropertyChangeListener(GameMaster.this);
        }
    }

    private static enum flagColors {
        R,
        B,
        G;

    }
}

