/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.DR;
import gurpsinittool.data.Damage;
import gurpsinittool.data.DamageExpression;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HitLocations {
    private static final Logger LOG = Logger.getLogger(HitLocations.class.getName());
    private static HashMap<LocationType, HitLocation> locations = new HashMap();

    static {
        HitLocations.addLocation(new HitLocation(LocationType.Skull, -7, "Penalty: -7(f)/-5(b). Attack that misses by 1 hits the torso instead. The skull gets an extra DR 2. Wounding modifier is \u00d74. Knockdown rolls are at -10. Critical hits use the Critical Head Blow Table (B556). Exception: These special effects do not apply to tox damage.", -10, true, "2"){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                return 4.0;
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Face, -5, "Penalty: -5(f)/-7(b). Attack that misses by 1 hits the torso instead. Jaw, cheeks, nose, ears, etc. If the target has an open-faced helmet, ignore its DR. Knockdown rolls are at -5. Critical hits use the Critical Head Blow Table (B556). Cor damage gets a \u00d71.5 wounding modifier, and if it inflicts a major wound, it also blinds one eye (both eyes on damage over full HP).", -5, true){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case cor: {
                        return 1.5;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Leg, -2, "Reduce the wounding multiplier of large pi, huge pi and imp damage to \u00d71. Any major wound (loss of over 1/2 HP from one blow) cripples the limb. Damage beyond that threshold is lost. Crit hits a joint.", 0, 0.5){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi4: 
                    case pi44: {
                        return 1.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Knee, -5, "Reduce the wounding multiplier of large pi, huge pi and imp damage to \u00d71. Any major wound (loss of over 1/3 HP from one blow) cripples the limb. HT rolls to recover from crippling are at -2. Damage beyond that threshold is lost. Dismemberment requires same amount as Leg. Miss by 1 hits the leg.", 0, 0.3333333333333333){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi4: 
                    case pi44: {
                        return 1.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Arm, -2, "If holding a shield, double the penalty to hit. Reduce the wounding multiplier of large pi, huge pi and imp damage to \u00d71. Any major wound (loss of over 1/2 HP from one blow) cripples the limb. Damage beyond that threshold is lost. Crit hits a joint.", 0, 0.5){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi4: 
                    case pi44: {
                        return 1.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Torso, 0, ""));
        HitLocations.addLocation(new HitLocation(LocationType.Hand, -4, "If holding a shield, double the penalty to hit. Reduce the wounding multiplier of large pi, huge pi and imp damage to \u00d71. Any major wound (loss of over 1/3 HP from one blow) cripples the extremity. Damage beyond that threshold is lost. Crit hits a joint.", 0, 0.3333333333333333){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi4: 
                    case pi44: {
                        return 1.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Foot, -4, "Reduce the wounding multiplier of large pi, huge pi and imp damage to \u00d71. Any major wound (loss of over 1/3 HP from one blow) cripples the extremity. Damage beyond that threshold is lost. Crit hits a joint.", 0, 0.3333333333333333){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi4: 
                    case pi44: {
                        return 1.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Neck, -5, "Attack that misses by 1 hits the torso instead. Increase the wounding multiplier of cr and cor attacks to \u00d71.5, and that of cutting damage to \u00d72. At the GM\u2019s option, anyone killed by a cutting blow to the neck is decapitated!"){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case cor: 
                    case cr: {
                        return 1.5;
                    }
                    case cut: {
                        return 2.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Vitals, -3, "Attack that misses by 1 hits the torso instead. Heart, lungs, kidneys, etc. Increase wounding modifier for imp or pi attack to \u00d73. Increase wounding modifier for tbb attack to \u00d72. cr is only \u00d71. If caused shock roll vs. knockdown, -5 if major wound, other attacks cannot target the vitals.", -5){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                switch (type) {
                    case imp: 
                    case pi: {
                        return 3.0;
                    }
                    case tbb: {
                        return 2.0;
                    }
                }
                return super.getWoundingModifier(type);
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Eye, -9, "Attack that misses by 1 hits the torso instead. Only imp, pi, and tbb attacks can target the eye \u2013 and only from the front or sides. Injury over HP/10 blinds the eye. Wounding modifier is \u00d74. Knockdown rolls are at -10. Critical hits use the Critical Head Blow Table (B556). Exception: These special effects do not apply to tox damage.", -10, true){

            @Override
            public double getWoundingModifier(DamageExpression.DamageType type) {
                return 4.0;
            }
        });
        HitLocations.addLocation(new HitLocation(LocationType.Groin, -3, "Attack that misses by 1 hits the torso instead. Human males/males of similar species suffer double shock from cr damage, and get -5 to knockdown rolls. Otherwise, treat as a torso hit.", -5));
    }

    public static HitLocation getLocation(LocationType type) {
        return locations.get((Object)type);
    }

    public static HitLocation getLocationFromName(String name) {
        LocationType[] locationTypeArray = LocationType.values();
        int n = locationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocationType location = locationTypeArray[n2];
            if (location.name().equals(name)) {
                return locations.get((Object)location);
            }
            ++n2;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("unable to find location based on name: " + name);
        }
        return null;
    }

    private static void addLocation(HitLocation location) {
        locations.put(location.type, location);
    }

    public static class HitLocation {
        public LocationType type;
        public int penalty;
        public String notes;
        public DR extraDR;
        public int knockdownPenalty;
        public boolean headWound;
        public double cripplingThreshold;

        HitLocation(LocationType type, int penalty, String notes) {
            this(type, penalty, notes, 0, false, "");
        }

        HitLocation(LocationType type, int penalty, String notes, int knockdownPenalty) {
            this(type, penalty, notes, knockdownPenalty, false, "");
        }

        HitLocation(LocationType type, int penalty, String notes, int knockdownPenalty, double cripplingThreshold) {
            this(type, penalty, notes, knockdownPenalty, false, "");
            this.cripplingThreshold = cripplingThreshold;
        }

        HitLocation(LocationType type, int penalty, String notes, int knockdownPenalty, boolean headWound) {
            this(type, penalty, notes, knockdownPenalty, headWound, "");
        }

        HitLocation(LocationType type, int penalty, String notes, int knockdownPenalty, boolean headWound, String extraDR) {
            block2: {
                this.cripplingThreshold = 0.0;
                this.type = type;
                this.penalty = penalty;
                this.notes = notes;
                this.knockdownPenalty = knockdownPenalty;
                this.headWound = headWound;
                try {
                    this.extraDR = DR.parseDR(extraDR);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block2;
                    LOG.severe("Failed to parse location DR field! '" + extraDR + "': " + e.getMessage());
                }
            }
        }

        public double getWoundingModifier(DamageExpression.DamageType type) {
            return Damage.getWoundingModifier(type);
        }
    }

    public static enum LocationType {
        Torso,
        Skull,
        Face,
        Leg,
        Knee,
        Arm,
        Hand,
        Foot,
        Neck,
        Vitals,
        Eye,
        Groin;

    }
}

