/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data.traits;

import gurpsinittool.data.Actor;
import gurpsinittool.data.Damage;
import gurpsinittool.data.DamageExpression;
import gurpsinittool.data.HitLocations;
import gurpsinittool.data.traits.Vulnerability;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InjuryTolerance {
    private static final Logger LOG = Logger.getLogger(Vulnerability.class.getName());
    private static HashSet<TT> toleranceSet = new HashSet();

    public static void reportDebugTrait(Actor actor) {
        InjuryTolerance.getTolerances(actor);
        String value = "";
        for (TT tolerance : toleranceSet) {
            value = String.valueOf(value) + (Object)((Object)tolerance) + ", ";
        }
        value = value.equals("") ? "none" : value;
        actor.setTemp("_InjuryTolerance", value);
    }

    private static void getTolerances(Actor actor) {
        ArrayList<String> tolerances = actor.getTraitValueArray("Injury Tolerance");
        toleranceSet.clear();
        for (String tolerance : tolerances) {
            if (tolerance.equals("no brain")) {
                toleranceSet.add(TT.NoBrain);
                continue;
            }
            if (tolerance.equals("no eyes")) {
                toleranceSet.add(TT.NoEyes);
                continue;
            }
            if (tolerance.equals("no head")) {
                toleranceSet.add(TT.NoHead);
                continue;
            }
            if (tolerance.equals("no neck")) {
                toleranceSet.add(TT.NoNeck);
                continue;
            }
            if (tolerance.equals("no vitals")) {
                toleranceSet.add(TT.NoVitals);
                continue;
            }
            if (tolerance.equals("diffuse")) {
                toleranceSet.add(TT.Diffuse);
                continue;
            }
            if (tolerance.equals("homogenous")) {
                toleranceSet.add(TT.Homeogenous);
                continue;
            }
            if (tolerance.equals("unliving")) {
                toleranceSet.add(TT.Unliving);
                continue;
            }
            if (tolerance.equals("damage reduction 2")) {
                toleranceSet.add(TT.DR2);
                continue;
            }
            if (tolerance.equals("damage reduction 3")) {
                toleranceSet.add(TT.DR3);
                continue;
            }
            if (tolerance.equals("damage reduction 4")) {
                toleranceSet.add(TT.DR4);
                continue;
            }
            if (!LOG.isLoggable(Level.INFO)) continue;
            LOG.info("Unrecognized injury tolerance type: '" + tolerance + "'");
        }
    }

    public static int getInjuryLimit(Actor actor, Damage damage) {
        InjuryTolerance.getTolerances(actor);
        if (toleranceSet.contains((Object)TT.Diffuse)) {
            if (damage.explosive) {
                return Integer.MAX_VALUE;
            }
            return InjuryTolerance.damageMaxDiffuse(damage.type);
        }
        return Integer.MAX_VALUE;
    }

    private static int damageMaxDiffuse(DamageExpression.DamageType type) {
        switch (type) {
            case imp: 
            case pi_: 
            case pi: 
            case pi4: 
            case pi44: {
                return 1;
            }
            case burn: 
            case cor: 
            case cr: 
            case cut: 
            case tbb: 
            case tox: {
                return 2;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("damageMaxDiffuse: Unhandled type! " + type.toString());
        }
        return 0;
    }

    public static double getDamageReduction(Actor actor) {
        InjuryTolerance.getTolerances(actor);
        if (toleranceSet.contains((Object)TT.DR2)) {
            return 2.0;
        }
        if (toleranceSet.contains((Object)TT.DR3)) {
            return 3.0;
        }
        if (toleranceSet.contains((Object)TT.DR4)) {
            return 4.0;
        }
        return 1.0;
    }

    public static HitLocations.HitLocation getAdjustedLocation(Actor actor, HitLocations.HitLocation location) {
        InjuryTolerance.getTolerances(actor);
        if ((toleranceSet.contains((Object)TT.NoBrain) || toleranceSet.contains((Object)TT.Diffuse) || toleranceSet.contains((Object)TT.Homeogenous)) && (location.type == HitLocations.LocationType.Skull || location.type == HitLocations.LocationType.Eye)) {
            location = HitLocations.getLocation(HitLocations.LocationType.Face);
        }
        if (toleranceSet.contains((Object)TT.NoEyes) && location.type == HitLocations.LocationType.Eye) {
            location = HitLocations.getLocation(HitLocations.LocationType.Face);
        }
        if (toleranceSet.contains((Object)TT.NoHead) && (location.type == HitLocations.LocationType.Face || location.type == HitLocations.LocationType.Skull)) {
            location = HitLocations.getLocation(HitLocations.LocationType.Torso);
        }
        if (toleranceSet.contains((Object)TT.NoNeck) && location.type == HitLocations.LocationType.Neck) {
            location = HitLocations.getLocation(HitLocations.LocationType.Torso);
        }
        if ((toleranceSet.contains((Object)TT.NoVitals) || toleranceSet.contains((Object)TT.Diffuse) || toleranceSet.contains((Object)TT.Homeogenous)) && (location.type == HitLocations.LocationType.Vitals || location.type == HitLocations.LocationType.Groin)) {
            location = HitLocations.getLocation(HitLocations.LocationType.Torso);
        }
        return location;
    }

    public static double getWoundingModifier(Actor actor, DamageExpression.DamageType type, Double locationWoundingModifier) {
        InjuryTolerance.getTolerances(actor);
        if (locationWoundingModifier > Damage.getWoundingModifier(type)) {
            return locationWoundingModifier;
        }
        if (toleranceSet.contains((Object)TT.Homeogenous)) {
            return InjuryTolerance.woundingModifierHomogenous(type);
        }
        if (toleranceSet.contains((Object)TT.Unliving)) {
            return InjuryTolerance.woundingModifierUnliving(type);
        }
        return locationWoundingModifier;
    }

    public static double woundingModifierUnliving(DamageExpression.DamageType type) {
        switch (type) {
            case pi_: {
                return 0.2;
            }
            case pi: {
                return 0.334;
            }
            case pi4: {
                return 0.5;
            }
            case imp: 
            case pi44: {
                return 1.0;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0.0;
    }

    public static double woundingModifierHomogenous(DamageExpression.DamageType type) {
        switch (type) {
            case pi_: {
                return 0.1;
            }
            case pi: {
                return 0.2;
            }
            case pi4: {
                return 0.334;
            }
            case imp: 
            case pi44: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0.0;
    }

    private static enum TT {
        NoBrain,
        NoEyes,
        NoHead,
        NoNeck,
        NoVitals,
        Diffuse,
        Homeogenous,
        Unliving,
        DR2,
        DR3,
        DR4;

    }
}

