/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data.traits;

import gurpsinittool.data.Actor;
import gurpsinittool.data.DamageExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Vulnerability {
    private static final Logger LOG = Logger.getLogger(Vulnerability.class.getName());
    private static HashMap<DamageExpression.DamageType, Integer> vulns = new HashMap();

    public static void reportDebugTrait(Actor actor) {
        Vulnerability.getVulns(actor);
        String value = "";
        for (Map.Entry<DamageExpression.DamageType, Integer> entry : vulns.entrySet()) {
            value = String.valueOf(value) + (Object)((Object)entry.getKey()) + ":" + entry.getValue() + ", ";
        }
        value = value.equals("") ? "none" : value;
        actor.setTemp("_Vulnerability", value);
    }

    private static void getVulns(Actor actor) {
        ArrayList<String> vulnerabilities = actor.getTraitValueArray("Vulnerability");
        Pattern vulnPattern = Pattern.compile("^([\\w\\+-]+)\\s*(?:\\*|x)\\s*(\\d+)$");
        vulns.clear();
        for (String vuln : vulnerabilities) {
            Matcher matcher = vulnPattern.matcher(vuln);
            if (matcher.matches()) {
                String vulnName = matcher.group(1);
                int vulnValue = Integer.valueOf(matcher.group(2));
                try {
                    DamageExpression.DamageType type = DamageExpression.parseType(vulnName);
                    vulns.put(type, vulnValue);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info("Unrecognized damage type: '" + vulnName + "'");
                }
                continue;
            }
            if (!LOG.isLoggable(Level.INFO)) continue;
            LOG.info("Unable to break down vulnerability: '" + vuln + "'");
        }
    }

    public static int getVulnerabilityMultiplier(Actor actor, DamageExpression.DamageType type) {
        Vulnerability.getVulns(actor);
        int vulnFinalMult = 1;
        if (vulns.containsKey((Object)type)) {
            vulnFinalMult = vulns.get((Object)type);
        }
        return vulnFinalMult;
    }
}

