/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.gca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCATrait {
    private static final Logger LOG = Logger.getLogger(GCATrait.class.getName());
    private String section;
    private Integer idNum;
    private String name;
    private HashMap<String, String> values;
    private ArrayList<GCATrait> children;

    public GCATrait(String section, HashMap<String, String> idKey) {
        this.section = section;
        if (!idKey.containsKey("idkey") && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("idKey hash does not contain 'idkey' value!");
        }
        if (!idKey.containsKey("name") && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("idKey hash does not contain 'name' value!");
        }
        this.idNum = Integer.valueOf(idKey.get("idkey"));
        this.name = idKey.get("name");
        idKey.remove("idkey");
        idKey.remove("name");
        this.values = new HashMap<String, String>(idKey);
        this.children = new ArrayList();
    }

    public boolean hasValue(String name) {
        return this.values.containsKey(name);
    }

    public String getValue(String name) {
        return this.values.get(name);
    }

    public List<String> getValueAsList(String name) {
        String value = this.values.get(name);
        if (value == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split("\\|"));
    }

    public void addChild(GCATrait child) {
        this.children.add(child);
    }

    public Iterable<GCATrait> getChildren() {
        return this.children;
    }

    public String getSection() {
        return this.section;
    }

    public Integer getIdNum() {
        return this.idNum;
    }

    public String getName() {
        return this.name;
    }
}

