/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PopupStatusEditList {
    protected JList<ActorBase.ActorStatus> list;
    protected JPanel editorPanel;
    protected JPopupMenu popupStatusMenu;
    protected Actor currentActor;

    public PopupStatusEditList() {
        this.initializeList();
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add(this.list, "Center");
        this.popupStatusMenu = new JPopupMenu();
        this.popupStatusMenu.add(this.editorPanel);
        JMenuItem menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupStatusEditList.this.setActorStatuses();
            }
        });
        menuItem.setText("Set");
        menuItem.setMnemonic(83);
        this.popupStatusMenu.add(menuItem);
        menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupStatusEditList.this.clearActorStatuses();
            }
        });
        menuItem.setText("Clear All");
        menuItem.setMnemonic(67);
        this.popupStatusMenu.add(menuItem);
        this.list.setBackground(this.popupStatusMenu.getBackground());
        this.list.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
    }

    private void initializeList() {
        this.list = new JList<ActorBase.ActorStatus>(ActorBase.ActorStatus.values());
        this.list.setVisibleRowCount(ActorBase.ActorStatus.values().length);
        this.list.setSelectionMode(2);
        this.list.setSelectionModel(new DefaultListSelectionModel(){
            boolean gestureStarted = false;
            boolean adding = true;

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.getValueIsAdjusting() && !this.gestureStarted && index0 != -1 && index1 != -1) {
                    this.adding = !super.isSelectedIndex(index0);
                    this.gestureStarted = true;
                }
                if (!this.getValueIsAdjusting() || this.adding) {
                    super.addSelectionInterval(index0, index1);
                } else {
                    super.removeSelectionInterval(index0, index1);
                }
            }

            @Override
            public void setValueIsAdjusting(boolean isAdjusting) {
                if (!isAdjusting) {
                    this.gestureStarted = false;
                }
                super.setValueIsAdjusting(isAdjusting);
            }
        });
    }

    public void show(Actor actor, Component comp, int x, int y) {
        this.currentActor = actor;
        this.refreshStatusSelection();
        this.popupStatusMenu.setPreferredSize(new Dimension(comp.getSize().width, this.popupStatusMenu.getPreferredSize().height));
        this.popupStatusMenu.show(comp, x, y);
    }

    protected void refreshStatusSelection() {
        this.list.clearSelection();
        for (ActorBase.ActorStatus status : this.currentActor.getAllStatuses()) {
            this.list.setSelectedValue((Object)status, true);
        }
    }

    protected void setActorStatuses() {
        HashSet<ActorBase.ActorStatus> statuses = new HashSet<ActorBase.ActorStatus>(this.list.getSelectedValuesList());
        this.currentActor.setAllStatuses(statuses);
    }

    protected void clearActorStatuses() {
        this.currentActor.setAllStatuses(new HashSet<ActorBase.ActorStatus>());
    }
}

