/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

public final class MiscUtil {
    private static final Logger LOG = Logger.getLogger(MiscUtil.class.getName());

    private MiscUtil() {
    }

    public static String formatDoubleNicely(Double doub) {
        String output = String.valueOf(doub);
        output = output.replaceAll("0+$", "");
        output = output.replaceAll("\\.$", "");
        return output;
    }

    public static String decodeRTFNotes(String rtfString) {
        String decoded;
        block4: {
            decoded = null;
            RTFEditorKit rtfParser = new RTFEditorKit();
            Document document = rtfParser.createDefaultDocument();
            try {
                rtfParser.read(new ByteArrayInputStream(rtfString.getBytes()), document, 0);
                decoded = document.getText(0, document.getLength());
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (BadLocationException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return decoded;
    }

    public static int parseIntSafe(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Error parsing value: '" + text + "'");
            }
            return 0;
        }
    }

    public static Color blend(Color color0, Color color1) {
        double totalAlpha = color0.getAlpha() + color1.getAlpha();
        double weight0 = (double)color0.getAlpha() / totalAlpha;
        double weight1 = (double)color1.getAlpha() / totalAlpha;
        double red = weight0 * (double)color0.getRed() + weight1 * (double)color1.getRed();
        double green = weight0 * (double)color0.getGreen() + weight1 * (double)color1.getGreen();
        double blue = weight0 * (double)color0.getBlue() + weight1 * (double)color1.getBlue();
        double alpha = Math.max(color0.getAlpha(), color1.getAlpha());
        return new Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static Color setAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void validateOnScreen(Component component) {
        Rectangle window = component.getBounds();
        Rectangle virtualscreen = new Rectangle();
        GraphicsDevice[] graphicsDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int j = 0;
        while (j < graphicsDevices.length) {
            GraphicsConfiguration[] graphicsConfig = graphicsDevices[j].getConfigurations();
            int i = 0;
            while (i < graphicsConfig.length) {
                virtualscreen = virtualscreen.union(graphicsConfig[i].getBounds());
                ++i;
            }
            ++j;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Testing window position: screen: " + virtualscreen + " window: " + window);
        }
        if (!virtualscreen.contains(window)) {
            MiscUtil.verifyWindowTopLeft(window, virtualscreen);
            MiscUtil.verifyWindowSize(window, virtualscreen);
            MiscUtil.verifyWindowBottomRight(window, virtualscreen);
        }
        component.setLocation(window.x, window.y);
    }

    private static void verifyWindowTopLeft(Rectangle window, Rectangle virtualscreen) {
        if (window.x < virtualscreen.x) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: translating +x");
            }
            window.translate(virtualscreen.x - window.x, 0);
        }
        if (window.y < virtualscreen.y) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: translating +y");
            }
            window.translate(0, virtualscreen.y - window.y);
        }
    }

    private static void verifyWindowSize(Rectangle window, Rectangle virtualscreen) {
        if (window.height > virtualscreen.height) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: resizing: smaller height");
            }
            window.height = virtualscreen.height;
        }
        if (window.width > virtualscreen.width) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: resizing: smaller width");
            }
            window.width = virtualscreen.width;
        }
    }

    private static void verifyWindowBottomRight(Rectangle window, Rectangle virtualscreen) {
        if (window.x + window.width > virtualscreen.x + virtualscreen.width) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: translating -x");
            }
            window.translate(virtualscreen.x + virtualscreen.width - (window.x + window.width), 0);
        }
        if (window.y + window.height > virtualscreen.y + virtualscreen.height) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Window out of screen: translating -y");
            }
            window.translate(0, virtualscreen.y + virtualscreen.height - (window.y + window.height));
        }
    }

    public static JButton noTextButton(Action action) {
        JButton button = new JButton(action);
        button.setText("");
        return button;
    }

    public static void setLabelFontStyle(JLabel label, int style) {
        Font oldFont = label.getFont();
        Font newFont = new Font(oldFont.getName(), style, oldFont.getSize());
        label.setFont(newFont);
    }

    public static void setTextFieldFontStyle(JTextField field, int style) {
        Font oldFont = field.getFont();
        Font newFont = new Font(oldFont.getName(), style, oldFont.getSize());
        field.setFont(newFont);
    }

    public static void setLabelBold(JLabel label) {
        Font oldFont = label.getFont();
        Font newFont = new Font(oldFont.getName(), 1, oldFont.getSize());
        label.setFont(newFont);
    }

    public static void setLabelItalic(JLabel label) {
        Font oldFont = label.getFont();
        Font newFont = new Font(oldFont.getName(), 2, oldFont.getSize());
        label.setFont(newFont);
    }

    public static void setLabelNormal(JLabel label) {
        Font oldFont = label.getFont();
        Font newFont = new Font(oldFont.getName(), 0, oldFont.getSize());
        label.setFont(newFont);
    }

    public static void setTextFieldItalic(JTextField field) {
        Font oldFont = field.getFont();
        Font newFont = new Font(oldFont.getName(), 2, oldFont.getSize());
        field.setFont(newFont);
    }

    public static void setTextFieldNormal(JTextField field) {
        Font oldFont = field.getFont();
        Font newFont = new Font(oldFont.getName(), 0, oldFont.getSize());
        field.setFont(newFont);
    }
}

