/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.GroupTreeTransferHandler;
import gurpsinittool.app.InitTable;
import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DropMode;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GroupTree
extends JTree
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private boolean clean = true;
    protected EventListenerList fileChangeListenerList = new EventListenerList();
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private InitTable groupTable;
    private JPopupMenu popupMenu;

    public GroupTree(InitTable groupTable) {
        super(new DefaultTreeModel(new GroupTreeNode("Groups", true)));
        this.groupTable = groupTable;
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setTransferHandler(new GroupTreeTransferHandler(this, "name"));
        this.getSelectionModel().setSelectionMode(1);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createMenuItem("New Folder", 70));
        this.popupMenu.add(this.createMenuItem("New Group", 71));
        this.popupMenu.add(this.createMenuItem("Delete", 127));
        MousePopupListener popupListener = new MousePopupListener();
        this.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        System.out.println("GroupTree: actionPerformed: Received action command " + e.getActionCommand());
        if ("New Folder".equals(e.getActionCommand())) {
            GroupTreeNode newFolder = this.addFolder("New Folder...");
            TreePath folderPath = new TreePath(newFolder.getPath());
            this.selectionModel.setSelectionPath(folderPath);
            System.out.println("GroupTree: actionPerformed: Added new node. User object " + newFolder.getUserObject().getClass());
            this.startEditingAtPath(folderPath);
        } else if ("New Group".equals(e.getActionCommand())) {
            GroupTreeNode newGroup = this.addGroup("New Group...");
            TreePath groupPath = new TreePath(newGroup.getPath());
            this.selectionModel.setSelectionPath(groupPath);
            System.out.println("GroupTree: actionPerformed: Added new node. User object " + newGroup.getUserObject().getClass());
            this.startEditingAtPath(groupPath);
        } else if ("Delete".equals(e.getActionCommand()) && (result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this group?", "Confirm Group Delete", 2)) == 0) {
            this.removeCurrentNode();
        }
    }

    public GroupTreeNode addGroup(String name) {
        GroupTreeNode newGroup = new GroupTreeNode(name, false);
        this.insertObjectAtSelection(newGroup);
        this.scrollPathToVisible(new TreePath(newGroup.getPath()));
        return newGroup;
    }

    public GroupTreeNode addFolder(String name) {
        GroupTreeNode newFolder = new GroupTreeNode(name, true);
        this.insertObjectAtSelection(newFolder);
        this.scrollPathToVisible(new TreePath(newFolder.getPath()));
        return newFolder;
    }

    private JMenuItem createMenuItem(String text, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public InitTable getGroupTable() {
        return this.groupTable;
    }

    private void insertObjectAtSelection(GroupTreeNode child) {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            System.out.println("GroupTree: insertObjectAtSelection: Inserting child at root node " + this.rootNode.getChildCount());
            this.treeModel.insertNodeInto(child, this.rootNode, this.rootNode.getChildCount());
        } else {
            GroupTreeNode node = (GroupTreeNode)selectionPath.getLastPathComponent();
            System.out.println("GroupTree: insertObjectAtSelection: Inserting child. Selection is node: " + node.toString());
            if (node.isFolder()) {
                this.treeModel.insertNodeInto(child, node, node.getChildCount());
            } else {
                GroupTreeNode parentNode = (GroupTreeNode)node.getParent();
                this.treeModel.insertNodeInto(child, parentNode, parentNode.getChildCount());
            }
        }
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            this.setDirty();
            return;
        }
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean() {
        if (!this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this, true));
        }
        this.clean = true;
    }

    public void setDirty() {
        System.out.println("GroupTree: setDirty");
        if (this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this, false));
        }
        this.fireFileChangedEvent(new FileChangeEvent(this));
        this.clean = false;
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.add(FileChangeEventListener.class, listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.remove(FileChangeEventListener.class, listener);
    }

    void fireFileChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileChangeOccured(evt);
            }
            i += 2;
        }
    }

    void fireFileCleanStatusChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileCleanStatusChanged(evt);
            }
            i += 2;
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.treeModel = (DefaultTreeModel)newModel;
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.treeModel.addTreeModelListener(new GroupTreeModelListener());
    }

    class GroupTreeModelListener
    implements TreeModelListener {
        GroupTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            System.out.println("GroupTreeModelListener: treeNodesChanged.");
            GroupTree.this.setDirty();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            System.out.println("GroupTreeModelListener: treeNodesInserted.");
            GroupTree.this.setDirty();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            System.out.println("GroupTreeModelListener: treeNodesRemoved.");
            GroupTree.this.setDirty();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
            System.out.println("GroupTreeModelListener: treeStructureChanged.");
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GroupTree.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

