/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;

public class InitTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private boolean clean = true;
    protected EventListenerList fileChangeListenerList = new EventListenerList();
    private String[] columnNames = new String[]{"Act", "Name", "Move", "Dodge", "HT", "HP", "Damage", "FP", "Fatigue", "State", "Type"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class, String.class};
    private static int numColumns = 11;
    private ArrayList<Actor> actorList = new ArrayList<Actor>(Arrays.asList(new Actor("new...", Actor.ActorState.Active, Actor.ActorType.Enemy)));
    private int activeActor = -1;

    public void addActor(Actor source, int dest) {
        if (dest > this.actorList.size() - 1) {
            dest = this.actorList.size() - 1;
        } else if (dest < 0) {
            dest = 0;
        }
        if (dest <= this.activeActor) {
            ++this.activeActor;
        }
        this.actorList.add(dest, source);
        this.setDirty();
        this.fireTableRowsInserted(dest, dest);
    }

    public void fireRefresh(Actor actor) {
        int[] rows = this.getActorRows(actor);
        int i = 0;
        while (i < rows.length) {
            this.setDirty();
            this.fireTableRowsUpdated(rows[i], rows[i]);
            ++i;
        }
    }

    public int getActiveActor() {
        return this.activeActor;
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return actor.Name;
            }
            case Move: {
                return actor.Move;
            }
            case Dodge: {
                return actor.Dodge;
            }
            case HT: {
                return actor.HT;
            }
            case HP: {
                return actor.HP;
            }
            case Damage: {
                return actor.Damage;
            }
            case FP: {
                return actor.FP;
            }
            case Fatigue: {
                return actor.Fatigue;
            }
            case State: {
                return actor.State;
            }
            case Type: {
                return actor.Type;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("ActorTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        switch (columns.values()[col]) {
            case State: {
                value = Actor.ActorState.valueOf((String)value);
                break;
            }
            case Type: {
                value = Actor.ActorType.valueOf((String)value);
            }
        }
        if (this.getValueAt(row, col).equals(value)) {
            System.out.println("ActorTableModel: setValueAt: values are identical. Exiting.");
            return;
        }
        if (row == this.actorList.size() - 1) {
            this.actorList.add(new Actor("new...", Actor.ActorState.Active, Actor.ActorType.Enemy));
            this.setDirty();
            this.fireTableRowsInserted(row + 1, row + 1);
        }
        Actor a = this.actorList.get(row);
        switch (columns.values()[col]) {
            case Name: {
                a.Name = (String)value;
                break;
            }
            case Move: {
                a.Move = (Integer)value;
                break;
            }
            case Dodge: {
                a.Dodge = (Integer)value;
                break;
            }
            case HT: {
                a.HT = (Integer)value;
                break;
            }
            case HP: {
                a.HP = (Integer)value;
                break;
            }
            case Damage: {
                a.Damage = (Integer)value;
                break;
            }
            case FP: {
                a.FP = (Integer)value;
                break;
            }
            case Fatigue: {
                a.Fatigue = (Integer)value;
                break;
            }
            case State: {
                a.State = (Actor.ActorState)((Object)value);
                break;
            }
            case Type: {
                a.Type = (Actor.ActorType)((Object)value);
            }
        }
        this.setDirty();
        int[] rows = this.getActorRows(a);
        int i = 0;
        while (i < rows.length) {
            this.fireTableRowsUpdated(rows[i], rows[i]);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (columns.values()[col]) {
            case Act: {
                return false;
            }
        }
        return true;
    }

    public boolean nextActor() {
        this.setDirty();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        boolean isNewRound = this.nextActorInternal();
        this.fireTableCellUpdated(this.activeActor, 0);
        return isNewRound;
    }

    protected boolean nextActorInternal() {
        boolean isNewRound = this.activeActor == -1;
        do {
            ++this.activeActor;
            if (this.activeActor < this.actorList.size() - 1) continue;
            this.activeActor = 0;
            isNewRound = true;
        } while (this.actorList.get((int)this.activeActor).State != Actor.ActorState.Active & this.actorList.get((int)this.activeActor).State != Actor.ActorState.Disabled);
        return isNewRound;
    }

    public void removeActor(int row) {
        this.actorList.remove(row);
        if (row < this.activeActor) {
            --this.activeActor;
        } else if (row == this.activeActor) {
            --this.activeActor;
            this.nextActor();
        }
        this.setDirty();
        this.fireTableRowsDeleted(row, row);
    }

    public void removeActor(Actor actor) {
        while (this.actorList.contains(actor)) {
            int row = this.actorList.indexOf(actor);
            this.actorList.remove(row);
            this.setDirty();
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void resetEncounter() {
        this.setDirty();
        this.fireTableCellUpdated(this.activeActor, 0);
        this.activeActor = -1;
    }

    public void setActorList(ArrayList<Actor> actorList) {
        this.fireTableRowsDeleted(0, this.getRowCount());
        this.actorList = actorList == null ? new ArrayList<Actor>(Arrays.asList(new Actor("new...", Actor.ActorState.Active, Actor.ActorType.Enemy))) : actorList;
        this.fireTableDataChanged();
    }

    public void setActiveRow(int row) {
        if (row > this.getRowCount() - 2) {
            throw new IndexOutOfBoundsException("Specified row is not an actor");
        }
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        this.activeActor = row;
        this.setValueAt(Actor.ActorState.Active.toString(), row, columns.State.ordinal());
        this.setDirty();
        this.fireTableCellUpdated(this.activeActor, 0);
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean() {
        if (!this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this, true));
        }
        this.clean = true;
    }

    public void setDirty() {
        System.out.println("GroupTree: setDirty");
        if (this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this, false));
        }
        this.fireFileChangedEvent(new FileChangeEvent(this));
        this.clean = false;
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.add(FileChangeEventListener.class, listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.remove(FileChangeEventListener.class, listener);
    }

    void fireFileChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileChangeOccured(evt);
            }
            i += 2;
        }
    }

    void fireFileCleanStatusChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileCleanStatusChanged(evt);
            }
            i += 2;
        }
    }

    public static enum columns {
        Act,
        Name,
        Move,
        Dodge,
        HT,
        HP,
        Damage,
        FP,
        Fatigue,
        State,
        Type;

    }
}

