/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.data.Actor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultTreeModel;

public class ActorGroupFile {
    private static final boolean DEBUG = false;
    public static int currentSchemaVer = 2;

    public static void OpenActorGroup(GroupTree groupTree, File openFile) {
        BufferedReader input;
        FileReader file;
        try {
            file = new FileReader(openFile);
            input = new BufferedReader(file);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return;
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new GroupTreeNode("Groups", true));
        try {
            Pattern startFile = Pattern.compile("^<GURPSActorGroupList schemaVer=\"(\\d+)\">$");
            String line = input.readLine();
            Matcher matcher = startFile.matcher(line);
            if (!matcher.matches()) {
                System.err.println("Error: first line does not specify start of ActorGroupList!");
                return;
            }
            int schemaVer = Integer.parseInt(matcher.group(1));
            switch (schemaVer) {
                case 0: {
                    ActorGroupFile.readSchema0(input, treeModel);
                    break;
                }
                case 1: {
                    ActorGroupFile.readSchema1(input, treeModel);
                    break;
                }
                case 2: {
                    ActorGroupFile.readSchema2(input, treeModel);
                }
            }
            input.close();
            file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        groupTree.setModel(treeModel);
    }

    public static void SaveActorGroup(GroupTree groupTree, File saveFile) {
        StringBuffer buffer = new StringBuffer();
        GroupTreeNode rootNode = (GroupTreeNode)groupTree.getModel().getRoot();
        ArrayList<GroupTreeNode> currentNodes = new ArrayList<GroupTreeNode>(Arrays.asList(rootNode));
        ArrayList<Integer> currentPositions = new ArrayList<Integer>(Arrays.asList(0));
        buffer.append("<GURPSActorGroupList schemaVer=\"" + currentSchemaVer + "\">\n");
        buffer.append("<GroupFolder name=\"" + rootNode.toString() + "\">\n");
        while (currentNodes.size() > 0) {
            if (currentPositions.get(0) >= currentNodes.get(0).getChildCount()) {
                currentNodes.remove(0);
                currentPositions.remove(0);
                buffer.append("</GroupFolder>\n");
                continue;
            }
            GroupTreeNode node = (GroupTreeNode)currentNodes.get(0).getChildAt(currentPositions.get(0));
            currentPositions.set(0, currentPositions.get(0) + 1);
            if (node.isFolder()) {
                buffer.append("<GroupFolder name=\"" + node.toString() + "\">\n");
                currentNodes.add(0, node);
                currentPositions.add(0, 0);
                continue;
            }
            buffer.append("<ActorGroup name=\"" + node.toString() + "\">\n");
            ArrayList<Actor> actorList = node.getActorList();
            int i = 0;
            while (i < actorList.size() - 1) {
                buffer.append(ActorGroupFile.SerializeActor(actorList.get(i)));
                ++i;
            }
            buffer.append("</ActorGroup>\n");
        }
        buffer.append("</GURPSActorGroupList>");
        String filename = saveFile.getPath();
        try {
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(buffer.toString());
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static String SerializeActor(Actor actor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<Actor name=\"" + actor.Name + "\" ht=\"" + actor.HT + "\" hp=\"" + actor.HP + "\" damage=\"" + actor.Damage + "\" fp=\"" + actor.FP + "\" fatigue=\"" + actor.Fatigue + "\" move=\"" + actor.Move + "\" dodge=\"" + actor.Dodge + "\" state=\"" + actor.State.toString() + "\" type=\"" + actor.Type.toString() + "\">\n");
        if (actor.Notes != null) {
            stringWriter.append("<notes>" + actor.Notes + "</notes>\n");
        }
        stringWriter.append("</Actor>\n");
        return stringWriter.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema2(BufferedReader input, DefaultTreeModel treeModel) {
        block13: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" dodge=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl69
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = new Actor(matcher.group(1), Actor.ActorState.valueOf(matcher.group(9)), Actor.ActorType.valueOf(matcher.group(10)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)));
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.Notes = matcher.group(1);
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (!matcher.matches()) continue;
                            actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                            while ((line = input.readLine()) != null) {
                                matcher = endNotes.matcher(line);
                                if (matcher.matches()) {
                                    actorNotes.append(matcher.group(1));
                                    currentActor.Notes = actorNotes.toString();
                                    continue block3;
                                }
                                actorNotes.append(String.valueOf(line) + "\n");
                            }
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block13;
lbl69:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl70:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema1(BufferedReader input, DefaultTreeModel treeModel) {
        block13: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl69
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = new Actor(matcher.group(1), Actor.ActorState.valueOf(matcher.group(5)), Actor.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 8);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.Notes = matcher.group(1);
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (!matcher.matches()) continue;
                            actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                            while ((line = input.readLine()) != null) {
                                matcher = endNotes.matcher(line);
                                if (matcher.matches()) {
                                    actorNotes.append(matcher.group(1));
                                    currentActor.Notes = actorNotes.toString();
                                    continue block3;
                                }
                                actorNotes.append(String.valueOf(line) + "\n");
                            }
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block13;
lbl69:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl70:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readSchema0(BufferedReader input, DefaultTreeModel treeModel) {
        GroupTreeNode currentNode = (GroupTreeNode)treeModel.getRoot();
        try {
            Pattern endFile = Pattern.compile("^</GURPSActorGroupList>$");
            Pattern startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
            Pattern endFolder = Pattern.compile("^</GroupFolder>$");
            Pattern startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
            Pattern endGroup = Pattern.compile("^</ActorGroup>$");
            Pattern actor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\"></Actor>$");
            String line = input.readLine();
            Matcher matcher = startFolder.matcher(line);
            if (!matcher.matches()) {
                System.err.println("Error: second line does not specify start of base folder!");
                return;
            }
            while (true) {
                GroupTreeNode newNode;
                String name;
                if ((line = input.readLine()) == null) {
                    return;
                }
                matcher = startFolder.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, true);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = startGroup.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, false);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = actor.matcher(line);
                if (matcher.matches()) {
                    Actor currentActor = new Actor(matcher.group(1), Actor.ActorState.valueOf(matcher.group(5)), Actor.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 8);
                    ArrayList<Actor> actorList = currentNode.getActorList();
                    actorList.add(actorList.size() - 1, currentActor);
                    continue;
                }
                matcher = endFolder.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endGroup.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endFile.matcher(line);
                if (matcher.matches()) break;
            }
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }
}

