/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.Actor;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

public class ActorDetailsPanel
extends JPanel
implements ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private InitTable initTable;
    private InitTableModel actorModel;
    private boolean actorLoaded = false;
    private int selectedActor = -1;
    private JButton add_attack;
    private JButton add_timer;
    private JPanel attacks;
    private JFormattedTextField damage;
    private JFormattedTextField dodge;
    private JFormattedTextField fatigue;
    private JFormattedTextField fp;
    private JFormattedTextField hp;
    private JFormattedTextField ht;
    private JFormattedTextField jFormattedTextField1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JFormattedTextField move;
    private JTextField name;
    private JTextArea notes;
    private JComboBox status;
    private JPanel timers;
    private JComboBox type;

    public ActorDetailsPanel(InitTable initTable) {
        this.initTable = initTable;
        this.actorModel = (InitTableModel)initTable.getModel();
        initTable.add(this);
        initTable.getSelectionModel().addListSelectionListener(this);
        this.actorModel.addTableModelListener(this);
        this.initComponents();
        this.name.getDocument().addDocumentListener(new ActorTextDocumentListener(textListenField.Name));
        this.notes.getDocument().addDocumentListener(new ActorTextDocumentListener(textListenField.Notes));
        this.disablePanel();
    }

    private void initComponents() {
        this.jFormattedTextField1 = new JFormattedTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.timers = new JPanel();
        this.add_timer = new JButton();
        this.attacks = new JPanel();
        this.add_attack = new JButton();
        this.status = new JComboBox();
        this.type = new JComboBox();
        this.jLabel7 = new JLabel();
        this.hp = new JFormattedTextField();
        this.damage = new JFormattedTextField();
        this.ht = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.notes = new JTextArea();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fp = new JFormattedTextField();
        this.move = new JFormattedTextField();
        this.fatigue = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.dodge = new JFormattedTextField();
        this.jSeparator2 = new JSeparator();
        this.name = new JTextField();
        this.jFormattedTextField1.setText("jFormattedTextField1");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jLabel2.setText("Status:");
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setText("Type:");
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setText("HT/HP:");
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setText("Damage:");
        this.timers.setBorder(BorderFactory.createTitledBorder("Timers"));
        this.add_timer.setText("Add Timer");
        this.add_timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.add_timerActionPerformed(evt);
            }
        });
        GroupLayout timersLayout = new GroupLayout(this.timers);
        this.timers.setLayout(timersLayout);
        timersLayout.setHorizontalGroup(timersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, timersLayout.createSequentialGroup().addContainerGap(78, Short.MAX_VALUE).addComponent(this.add_timer)));
        timersLayout.setVerticalGroup(timersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timersLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.add_timer)));
        this.attacks.setBorder(BorderFactory.createTitledBorder("Attacks"));
        this.add_attack.setText("Add Attack");
        this.add_attack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.add_attackActionPerformed(evt);
            }
        });
        GroupLayout attacksLayout = new GroupLayout(this.attacks);
        this.attacks.setLayout(attacksLayout);
        attacksLayout.setHorizontalGroup(attacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, attacksLayout.createSequentialGroup().addContainerGap(74, Short.MAX_VALUE).addComponent(this.add_attack)));
        attacksLayout.setVerticalGroup(attacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attacksLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.add_attack)));
        this.status.setModel(new DefaultComboBoxModel<String>(new String[]{"Active", "Waiting", "Disabled", "Unconscious", "Dead"}));
        this.status.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.statusActionPerformed(evt);
            }
        });
        this.type.setModel(new DefaultComboBoxModel<String>(new String[]{"PC", "Ally", "Enemy", "Neutral", "Special"}));
        this.type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.typeActionPerformed(evt);
            }
        });
        this.jLabel7.setFont(this.jLabel7.getFont().deriveFont(this.jLabel7.getFont().getStyle() | 1));
        this.jLabel7.setText("FP:");
        this.hp.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.hp.setText("99");
        this.hp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.hp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.hpPropertyChange(evt);
            }
        });
        this.damage.setForeground(new Color(220, 0, 0));
        this.damage.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.damage.setText("99");
        this.damage.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.damage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.damagePropertyChange(evt);
            }
        });
        this.ht.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.ht.setText("99");
        this.ht.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.ht.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.htPropertyChange(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText("Notes:");
        this.notes.setColumns(20);
        this.notes.setRows(5);
        this.jScrollPane1.setViewportView(this.notes);
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Move:");
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Dodge:");
        this.jLabel8.setFont(this.jLabel8.getFont().deriveFont(this.jLabel8.getFont().getStyle() | 1));
        this.jLabel8.setText("/");
        this.fp.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.fp.setText("99");
        this.fp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.fp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.fpPropertyChange(evt);
            }
        });
        this.move.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.move.setText("99");
        this.move.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.move.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.movePropertyChange(evt);
            }
        });
        this.fatigue.setForeground(new Color(220, 0, 0));
        this.fatigue.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.fatigue.setText("99");
        this.fatigue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.fatigue.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.fatiguePropertyChange(evt);
            }
        });
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jLabel6.setText("Fatigue:");
        this.dodge.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.dodge.setText("99");
        this.dodge.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.dodge.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.dodgePropertyChange(evt);
            }
        });
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setFont(new Font("Tahoma", 1, 20));
        this.name.setText("name");
        this.name.setBorder(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(150, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 175, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.timers, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attacks, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -1, 169, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel3, -2, 43, -2).addComponent(this.jLabel4)).addGap(21, 21, 21)).addComponent(this.jLabel6).addComponent(this.jLabel5)).addComponent(this.jLabel2, -2, 62, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.move, GroupLayout.Alignment.LEADING).addComponent(this.fatigue, GroupLayout.Alignment.LEADING).addComponent(this.fp, GroupLayout.Alignment.LEADING).addComponent(this.ht, GroupLayout.Alignment.LEADING, -1, 40, Short.MAX_VALUE).addComponent(this.dodge, -1, 41, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.damage).addComponent(this.hp, -1, 39, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.type, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.status, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)))).addComponent(this.jLabel10).addComponent(this.jLabel7)).addContainerGap(23, Short.MAX_VALUE)).addComponent(this.name, GroupLayout.Alignment.TRAILING, -1, 195, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.name, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.status, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.type, -2, -1, -2).addComponent(this.jLabel3)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ht, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel4, -2, 17, -2).addComponent(this.hp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.damage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.fp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fatigue, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.move, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.dodge, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jSeparator1, -2, 9, -2)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 114, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timers, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attacks, -2, -1, -2).addContainerGap()));
    }

    private void add_timerActionPerformed(ActionEvent evt) {
    }

    private void add_attackActionPerformed(ActionEvent evt) {
    }

    private void htPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.HT.ordinal(), ((Long)this.ht.getValue()).intValue());
        }
    }

    private void hpPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.HP.ordinal(), ((Long)this.hp.getValue()).intValue());
        }
    }

    private void damagePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Damage.ordinal(), ((Long)this.damage.getValue()).intValue());
        }
    }

    private void fpPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.FP.ordinal(), ((Long)this.fp.getValue()).intValue());
        }
    }

    private void fatiguePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Fatigue.ordinal(), ((Long)this.fatigue.getValue()).intValue());
        }
    }

    private void movePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Move.ordinal(), ((Long)this.move.getValue()).intValue());
        }
    }

    private void dodgePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Dodge.ordinal(), ((Long)this.dodge.getValue()).intValue());
        }
    }

    private void statusActionPerformed(ActionEvent evt) {
        if (this.actorLoaded) {
            this.setActorValue(InitTableModel.columns.State.ordinal(), ((JComboBox)evt.getSource()).getSelectedItem().toString());
        }
    }

    private void typeActionPerformed(ActionEvent evt) {
        if (this.actorLoaded) {
            this.setActorValue(InitTableModel.columns.Type.ordinal(), ((JComboBox)evt.getSource()).getSelectedItem().toString());
            this.refreshActor();
        }
    }

    private void fieldFocusGained(FocusEvent evt) {
        System.out.println("ActorDetailsPanel: Focus gained on " + evt.toString());
        JFormattedTextField t = (JFormattedTextField)evt.getComponent();
        t.setText(t.getText());
        t.selectAll();
    }

    public void disablePanel() {
        this.ht.setValue(10);
        this.ht.setEnabled(false);
        this.hp.setValue(10);
        this.hp.setEnabled(false);
        this.damage.setValue(0);
        this.damage.setEnabled(false);
        this.fp.setValue(10);
        this.fp.setEnabled(false);
        this.fatigue.setValue(0);
        this.fatigue.setEnabled(false);
        this.move.setValue(5);
        this.move.setEnabled(false);
        this.dodge.setValue(8);
        this.dodge.setEnabled(false);
        this.status.setSelectedIndex(0);
        this.status.setEnabled(false);
        this.type.setSelectedIndex(0);
        this.type.setEnabled(false);
        this.name.setText("");
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setEnabled(false);
        this.add_attack.setEnabled(false);
        this.add_timer.setEnabled(false);
        this.notes.setText("");
        this.notes.setEnabled(false);
    }

    private void enablePanel() {
        this.ht.setEnabled(true);
        this.hp.setEnabled(true);
        this.damage.setEnabled(true);
        this.fp.setEnabled(true);
        this.fatigue.setEnabled(true);
        this.move.setEnabled(true);
        this.dodge.setEnabled(true);
        this.status.setEnabled(true);
        this.type.setEnabled(true);
        this.name.setEnabled(true);
        this.add_attack.setEnabled(true);
        this.add_timer.setEnabled(true);
        this.notes.setEnabled(true);
    }

    public void refreshActor() {
        this.actorLoaded = false;
        if (this.initTable.getSelectedRow() == -1) {
            this.disablePanel();
            return;
        }
        this.enablePanel();
        this.selectedActor = this.initTable.getSelectedRow();
        Actor actor = this.actorModel.getActor(this.initTable.getSelectedRow());
        this.name.setText(actor.Name);
        switch (actor.Type) {
            case PC: {
                this.name.setBackground(new Color(200, 255, 200));
                break;
            }
            case Ally: {
                this.name.setBackground(new Color(200, 200, 255));
                break;
            }
            case Enemy: {
                this.name.setBackground(new Color(255, 200, 200));
                break;
            }
            case Neutral: {
                this.name.setBackground(new Color(200, 200, 200));
                break;
            }
            case Special: {
                this.name.setBackground(new Color(255, 200, 255));
            }
        }
        this.name.setForeground(new Color(0, 0, 0));
        switch (actor.State) {
            case Active: {
                break;
            }
            case Waiting: {
                break;
            }
            case Disabled: {
                break;
            }
            case Unconscious: 
            case Dead: {
                this.name.setForeground(new Color(128, 128, 128));
            }
        }
        this.status.setSelectedItem(actor.State.toString());
        this.type.setSelectedItem(actor.Type.toString());
        this.ht.setValue(Integer.valueOf(actor.HT).longValue());
        this.hp.setValue(Integer.valueOf(actor.HP).longValue());
        this.damage.setValue(Integer.valueOf(actor.Damage).longValue());
        this.fp.setValue(Integer.valueOf(actor.FP).longValue());
        this.fatigue.setValue(Integer.valueOf(actor.Fatigue).longValue());
        this.move.setValue(Integer.valueOf(actor.Move).longValue());
        this.dodge.setValue(Integer.valueOf(actor.Dodge).longValue());
        this.notes.setText(actor.Notes);
        this.actorLoaded = true;
    }

    protected void setActorValue(int column, Object value) {
        this.actorLoaded = false;
        this.actorModel.setValueAt(value, this.selectedActor, column);
        this.actorLoaded = true;
    }

    public void setActorModel(InitTableModel model) {
        if (this.actorModel != null) {
            this.actorModel.removeTableModelListener(this);
        }
        if (model != null) {
            model.addTableModelListener(this);
        }
        this.actorModel = model;
        this.refreshActor();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        System.out.println("ActorDetailsPanel: Table Model event: type = " + e.getType() + ", " + e.toString());
        if (this.actorLoaded) {
            this.refreshActor();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        System.out.println("ActorDetailsPanel: List Selection event: " + e.getSource().toString());
        if (!e.getValueIsAdjusting()) {
            this.refreshActor();
        }
    }

    protected class ActorTextDocumentListener
    implements DocumentListener {
        private textListenField lField;

        public ActorTextDocumentListener(textListenField field) {
            this.lField = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        private void processTextChanges(DocumentEvent e) {
            if (ActorDetailsPanel.this.actorLoaded) {
                Document document = e.getDocument();
                try {
                    switch (this.lField) {
                        case Name: {
                            ActorDetailsPanel.this.setActorValue(InitTableModel.columns.Name.ordinal(), document.getText(0, document.getLength()));
                            break;
                        }
                        case Notes: {
                            System.out.println("ActorTextDocumentListener: processTextChanges: Notes: updating actor");
                            ((ActorDetailsPanel)ActorDetailsPanel.this).actorModel.getActor((int)((ActorDetailsPanel)ActorDetailsPanel.this).selectedActor).Notes = document.getText(0, document.getLength());
                            ActorDetailsPanel.this.actorModel.setDirty();
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    protected static enum textListenField {
        Name,
        Notes;

    }
}

