/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupManager;
import gurpsinittool.app.InitTable;
import gurpsinittool.ui.ActorDetailsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GITApp
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private InitTable initTable;
    private ActorDetailsPanel detailsPanel;
    private GroupManager groupManager;
    private Properties propertyBag = new Properties();
    private JLabel roundCounter;
    private JSplitPane jSplitPaneHorizontal;

    private static void createAndShowGUI() {
        GITApp mainApp = new GITApp("GURPS Initiative Tool");
        mainApp.setDefaultCloseOperation(0);
        mainApp.loadProperties();
        mainApp.addComponentsToPane();
        if (Boolean.valueOf(mainApp.propertyBag.getProperty("GITApp.Manager.visible")).booleanValue()) {
            mainApp.groupManager.setVisible(true);
        }
        mainApp.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITApp.createAndShowGUI();
            }
        });
    }

    public GITApp(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("nextActor".equals(e.getActionCommand())) {
            if (this.initTable.nextActor()) {
                Integer currentRound = Integer.valueOf(this.roundCounter.getText()) + 1;
                this.roundCounter.setText(currentRound.toString());
                int minimumWidth = this.roundCounter.getMinimumSize().width / 10 * 10;
                if (this.roundCounter.getMinimumSize().width + 1 != 0) {
                    minimumWidth += 10;
                }
                this.roundCounter.setPreferredSize(new Dimension(minimumWidth, 20));
                System.out.println("Minimum round counter size = " + this.roundCounter.getMinimumSize().toString());
            }
        } else if ("resetRound".equals(e.getActionCommand())) {
            this.roundCounter.setText("0");
            this.initTable.resetEncounter();
        } else if ("openGroupManager".equals(e.getActionCommand())) {
            this.groupManager.setVisible(true);
        } else if ("sizeColumns".equals(e.getActionCommand())) {
            this.initTable.autoSizeColumns();
        }
    }

    private void addComponentsToPane() {
        this.groupManager = new GroupManager(this.propertyBag);
        this.setDefaultProperties();
        JMenuBar menubar = new JMenuBar();
        JMenu menuFile = new JMenu("Test");
        menuFile.add("test item1");
        menuFile.add("test item2");
        menuFile.add("test item3");
        menubar.add(menuFile);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar("Encounter Control Toolbar");
        JButton button = new JButton();
        URL imageURL = GITApp.class.getResource("/resources/images/control_play_blue.png");
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, "Next Actor"));
        }
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Step to next actor");
        button.setActionCommand("nextActor");
        button.setMnemonic(78);
        button.addActionListener(this);
        toolbar.add(button);
        JLabel label = new JLabel("Round:");
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        toolbar.add(label);
        label = new JLabel("0");
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        label.setPreferredSize(new Dimension(20, 20));
        this.roundCounter = label;
        toolbar.add(label);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_start_blue.png"), "Reset Encounter"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Reset the round counter");
        button.setActionCommand("resetRound");
        button.setMnemonic(82);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/script_code.png"), "Auto-size columns"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Auto re-size the table columns to best fit");
        button.setActionCommand("sizeColumns");
        button.setMnemonic(65);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/group.png"), "Group Manager"));
        button.setToolTipText("Manage Actor Groups");
        button.setActionCommand("openGroupManager");
        button.setMnemonic(71);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.setRollover(true);
        this.getContentPane().add((Component)toolbar, "First");
        this.initTable = new InitTable(true);
        JScrollPane tableScrollPane = new JScrollPane(this.initTable);
        this.detailsPanel = new ActorDetailsPanel(this.initTable);
        JScrollPane actorDetailsPane = new JScrollPane(this.detailsPanel);
        this.jSplitPaneHorizontal = new JSplitPane(1, tableScrollPane, actorDetailsPane);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.getContentPane().add((Component)this.jSplitPaneHorizontal, "Center");
        this.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.location.y")));
        this.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.size.height")));
        this.addWindowListener(new GITAppWindowListener());
    }

    private void loadProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            System.out.println("GITApp: loadProperties: Loading properties from file " + propertyFile.getAbsolutePath());
            FileInputStream propIn = new FileInputStream(propertyFile);
            this.propertyBag.load(propIn);
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: loadProperties: File not found? " + e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("GITApp: loadProperties: Error reading file! " + e.toString());
            e.printStackTrace();
        }
    }

    private boolean saveProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            System.out.println("GITApp: saveProperties: Saving properties to file " + propertyFile.getAbsolutePath());
            FileOutputStream propOut = new FileOutputStream(propertyFile);
            this.propertyBag.store(propOut, "GITApp Properties");
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: saveProperties: File not found? " + e.toString());
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("GITApp: saveProperties: Error writing to file! " + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("GITApp.Manager.visible")) {
            this.propertyBag.setProperty("GITApp.Manager.visible", "false");
        }
        if (!this.propertyBag.containsKey("GITApp.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", "460");
        }
        if (!this.propertyBag.containsKey("GITApp.location.x")) {
            this.propertyBag.setProperty("GITApp.location.x", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.location.y")) {
            this.propertyBag.setProperty("GITApp.location.y", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.size.width")) {
            this.propertyBag.setProperty("GITApp.size.width", "760");
        }
        if (!this.propertyBag.containsKey("GITApp.size.height")) {
            this.propertyBag.setProperty("GITApp.size.height", "480");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("GITApp.Manager.visible", String.valueOf(this.groupManager.isVisible()));
        this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("GITApp.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("GITApp.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("GITApp.size.height", String.valueOf(this.getSize().height));
    }

    class GITAppWindowListener
    implements WindowListener {
        GITAppWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            GITApp.this.updateProperties();
            GITApp.this.groupManager.updateProperties();
            if (GITApp.this.groupManager.querySaveChanges() && GITApp.this.saveProperties()) {
                System.exit(0);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }
}

