/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.ActorGroupFile;
import gurpsinittool.ui.ActorDetailsPanel;
import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;

public class GroupManager
extends JFrame
implements TreeSelectionListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private JSplitPane jSplitPaneVertical;
    private JSplitPane jSplitPaneHorizontal;
    private JScrollPane jScrollPaneTable;
    private JScrollPane jScrollPaneTree;
    private JScrollPane jScrollPaneDetails;
    private InitTable groupTable;
    private ActorDetailsPanel actorDetailsPanel;
    private JMenuBar jMenuBar;
    private JMenu jMenu;
    private GroupTree groupTree;
    private JFileChooser fileChooser;
    private File saveAsFile;
    private boolean tableIsClean = true;
    private boolean treeIsClean = true;
    private Properties propertyBag;

    public GroupManager(Properties propertyBag) {
        super("Group Manager");
        this.propertyBag = propertyBag;
        this.setDefaultProperties();
        this.setDefaultCloseOperation(1);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File("."));
        this.fileChooser.addChoosableFileFilter(new GroupFilter());
        this.jMenuBar = new JMenuBar();
        this.jMenu = new JMenu("File");
        this.jMenu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem("New", 78);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Open", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Save As...", 65);
        menuItem.getAccessibleContext().setAccessibleDescription("Select the file to save the group list to");
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Save the group list");
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.jMenu = new JMenu("Tools");
        this.jMenu.setMnemonic(84);
        menuItem = new JCheckBoxMenuItem("Auto-fit columns");
        menuItem.setMnemonic(65);
        menuItem.setSelected(Boolean.valueOf(propertyBag.getProperty("Manager.groupTable.autoResize")));
        menuItem.getAccessibleContext().setAccessibleDescription("Table columns auto-fit automatically");
        menuItem.addItemListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.jMenu = new JMenu("View");
        this.jMenu.setMnemonic(86);
        menuItem = new JCheckBoxMenuItem("Actor Details");
        menuItem.setSelected(Boolean.valueOf(propertyBag.getProperty("Manager.actorDetails.visible")));
        menuItem.setMnemonic(68);
        menuItem.addItemListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.setJMenuBar(this.jMenuBar);
        this.groupTable = new InitTable(false);
        this.groupTable.setVisible(false);
        this.groupTable.getActorTableModel().addFileChangeEventListener(new GroupFileChangeEventListener());
        this.groupTable.getActorTableModel().addTableModelListener(new GroupInitTableModelListener());
        this.actorDetailsPanel = new ActorDetailsPanel(this.groupTable);
        this.groupTree = new GroupTree(this.groupTable);
        this.groupTree.addTreeSelectionListener(this);
        this.groupTree.addFileChangeEventListener(new GroupFileChangeEventListener());
        this.jScrollPaneTable = new JScrollPane(this.groupTable);
        this.jScrollPaneDetails = new JScrollPane(this.actorDetailsPanel);
        this.jScrollPaneTree = new JScrollPane(this.groupTree);
        this.jSplitPaneVertical = new JSplitPane(0, this.jScrollPaneTree, this.jScrollPaneTable);
        this.jSplitPaneHorizontal = new JSplitPane(1, this.jSplitPaneVertical, this.jScrollPaneDetails);
        this.jSplitPaneVertical.setDividerLocation(Integer.valueOf(propertyBag.getProperty("Manager.splitVertical.dividerLocation")));
        this.jSplitPaneVertical.setContinuousLayout(true);
        this.jSplitPaneVertical.setResizeWeight(0.95);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(propertyBag.getProperty("Manager.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setContinuousLayout(true);
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.layoutActorPanel();
        this.setLocation(Integer.valueOf(propertyBag.getProperty("Manager.location.x")), Integer.valueOf(propertyBag.getProperty("Manager.location.y")));
        this.setSize(Integer.valueOf(propertyBag.getProperty("Manager.size.width")), Integer.valueOf(propertyBag.getProperty("Manager.size.height")));
        if (propertyBag.containsKey("Manager.currentLoadedFile")) {
            this.saveAsFile = new File(propertyBag.getProperty("Manager.currentLoadedFile"));
            this.loadGroupFile(this.saveAsFile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("GroupManager: actionPerformed: Received action command " + e.getActionCommand());
        if ("Save As...".equals(e.getActionCommand())) {
            this.saveGroupFile(null);
        } else if ("Save".equals(e.getActionCommand())) {
            this.saveGroupFile(this.saveAsFile);
        } else if ("Open".equals(e.getActionCommand()) && this.querySaveChanges()) {
            this.loadGroupFile(null);
        } else if ("New".equals(e.getActionCommand()) && this.querySaveChanges()) {
            this.newGroupFile();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        System.out.println("GroupManager: itemStateChanged: Received item state changed " + e.toString());
        JMenuItem source = (JMenuItem)e.getSource();
        if ("Actor Details".equals(source.getText())) {
            boolean selected = e.getStateChange() == 1;
            System.out.println("GroupManager: itemStateChanged: View/Actor Details item state changed. Selected = " + selected);
            this.propertyBag.setProperty("Manager.actorDetails.visible", String.valueOf(selected));
            this.layoutActorPanel();
        } else if ("Auto-fit columns".equals(source.getText())) {
            boolean selected = e.getStateChange() == 1;
            System.out.println("GroupManager: itemStateChanged: Tools/Auto-fit columns item state changed. Selected = " + selected);
            this.propertyBag.setProperty("Manager.groupTable.autoResize", String.valueOf(selected));
            if (selected) {
                this.groupTable.autoSizeColumns();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        System.out.println("GroupManager: valueChanged: TreeSelectionEvent: " + e.toString());
        if (this.groupTable.getCellEditor() != null) {
            this.groupTable.getCellEditor().stopCellEditing();
        }
        InitTableModel tableModel = this.groupTable.getActorTableModel();
        if (this.groupTree.getLastSelectedPathComponent() != null) {
            System.out.println("GroupManager: valueChanged: Current Selection: " + this.groupTree.getLastSelectedPathComponent().toString());
            GroupTreeNode node = (GroupTreeNode)this.groupTree.getLastSelectedPathComponent();
            if (!node.isFolder()) {
                tableModel.setActorList(node.getActorList());
                this.groupTable.setVisible(true);
            } else {
                this.groupTable.setVisible(false);
                tableModel.setActorList(null);
            }
        } else {
            System.out.println("GroupManager: valueChanged - Current Selection: null");
            this.groupTable.setVisible(false);
            tableModel.setActorList(null);
        }
    }

    public boolean querySaveChanges() {
        int n;
        return this.tableIsClean && this.treeIsClean || !((n = JOptionPane.showOptionDialog(this, "The group has been modified. Save Changes?", "Group Changed", 1, 3, null, null, null)) == 0 ? !this.saveGroupFile(this.saveAsFile) : n == 2);
    }

    public void newGroupFile() {
        System.out.println("GroupManager: newGroupFile: Creating new group list");
        this.groupTree.setModel(new DefaultTreeModel(new GroupTreeNode("Groups", true)));
        this.saveAsFile = null;
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager");
    }

    public boolean loadGroupFile(File file) {
        if (file == null) {
            System.out.println("GroupManager: loadGroupFile: Opening file: Displaying file chooser");
            int retVal = this.fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                file = this.fileChooser.getSelectedFile();
            } else {
                return false;
            }
        }
        System.out.println("GroupManager: loadGroupFile: Opening file: " + file.getName());
        ActorGroupFile.OpenActorGroup(this.groupTree, file);
        this.saveAsFile = file;
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager - " + this.saveAsFile.getName());
        return true;
    }

    public boolean saveGroupFile(File file) {
        if (file == null) {
            int retVal = this.fileChooser.showSaveDialog(this);
            System.out.println("GroupManager: saveGroupFile: Displaying file chooser");
            if (retVal == 0) {
                int response;
                file = this.fileChooser.getSelectedFile();
                if (!file.toString().contains(".")) {
                    file = new File(String.valueOf(file.toString()) + ".igroup");
                }
                if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        System.out.println("GroupManager: saveGroupFile: Saving group list as file: " + file.getName());
        ActorGroupFile.SaveActorGroup(this.groupTree, file);
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager - " + file.getName());
        this.saveAsFile = file;
        return true;
    }

    private void layoutActorPanel() {
        if (Boolean.valueOf(this.propertyBag.getProperty("Manager.actorDetails.visible")).booleanValue()) {
            this.getContentPane().remove(this.jSplitPaneVertical);
            this.jSplitPaneHorizontal.setLeftComponent(this.jSplitPaneVertical);
            this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("Manager.splitHorizontal.dividerLocation")));
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneHorizontal, -1, 400, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneHorizontal, -1, 300, Short.MAX_VALUE));
        } else {
            this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
            this.getContentPane().remove(this.jSplitPaneHorizontal);
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneVertical, -1, 400, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneVertical, -1, 300, Short.MAX_VALUE));
        }
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("Manager.actorDetails.visible")) {
            this.propertyBag.setProperty("Manager.actorDetails.visible", "true");
        }
        if (!this.propertyBag.containsKey("Manager.groupTable.autoResize")) {
            this.propertyBag.setProperty("Manager.groupTable.autoResize", "false");
        }
        if (!this.propertyBag.containsKey("Manager.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", "340");
        }
        if (!this.propertyBag.containsKey("Manager.splitVertical.dividerLocation")) {
            this.propertyBag.setProperty("Manager.splitVertical.dividerLocation", "200");
        }
        if (!this.propertyBag.containsKey("Manager.location.x")) {
            this.propertyBag.setProperty("Manager.location.x", "500");
        }
        if (!this.propertyBag.containsKey("Manager.location.y")) {
            this.propertyBag.setProperty("Manager.location.y", "300");
        }
        if (!this.propertyBag.containsKey("Manager.size.width")) {
            this.propertyBag.setProperty("Manager.size.width", "620");
        }
        if (!this.propertyBag.containsKey("Manager.size.height")) {
            this.propertyBag.setProperty("Manager.size.height", "450");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("Manager.splitVertical.dividerLocation", String.valueOf(this.jSplitPaneVertical.getDividerLocation()));
        this.propertyBag.setProperty("Manager.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("Manager.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("Manager.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("Manager.size.height", String.valueOf(this.getSize().height));
        if (this.saveAsFile != null) {
            this.propertyBag.setProperty("Manager.currentLoadedFile", this.saveAsFile.getAbsolutePath());
        } else {
            this.propertyBag.remove("Manager.currentLoadedFile");
        }
    }

    class GroupFileChangeEventListener
    implements FileChangeEventListener {
        GroupFileChangeEventListener() {
        }

        @Override
        public void fileChangeOccured(FileChangeEvent evt) {
            System.out.println("GroupManager: FileChangeOccured.");
        }

        @Override
        public void fileCleanStatusChanged(FileChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof InitTableModel) {
                System.out.println("GroupManager: FileCleanStatusChanged: ActorTableModel " + evt.isClean);
                GroupManager.this.tableIsClean = evt.isClean;
            } else if (source instanceof GroupTree) {
                System.out.println("GroupManager: FileCleanStatusChanged: GroupTree " + evt.isClean);
                GroupManager.this.treeIsClean = evt.isClean;
            } else {
                System.out.println("GroupManager: FileCleanStatusChanged: UNKNOWN " + evt.isClean);
            }
            if (GroupManager.this.tableIsClean && GroupManager.this.treeIsClean) {
                if (GroupManager.this.saveAsFile != null) {
                    GroupManager.this.setTitle("Group Manager - " + GroupManager.this.saveAsFile.getName());
                } else {
                    GroupManager.this.setTitle("Group Manager");
                }
            } else if (GroupManager.this.saveAsFile != null) {
                GroupManager.this.setTitle("Group Manager - " + GroupManager.this.saveAsFile.getName() + "*");
            } else {
                GroupManager.this.setTitle("Group Manager *");
            }
        }
    }

    private class GroupFilter
    extends FileFilter {
        private GroupFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.toString().endsWith(".igroup");
        }

        @Override
        public String getDescription() {
            return "InitTool Group (*.igroup)";
        }
    }

    class GroupInitTableModelListener
    implements TableModelListener {
        GroupInitTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            System.out.println("GroupManager: TableModelChange occured.");
            if (Boolean.valueOf(GroupManager.this.propertyBag.getProperty("Manager.groupTable.autoResize")).booleanValue()) {
                GroupManager.this.groupTable.autoSizeColumns();
            }
        }
    }
}

