/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupManager;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.Actor;
import gurpsinittool.ui.ActorDetailsPanel;
import gurpsinittool.ui.CriticalTablesDialog;
import gurpsinittool.ui.DefenseDialog;
import gurpsinittool.util.DieRoller;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.UndoManager;

public class GITApp
extends JFrame
implements ActionListener,
EncounterLogEventListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private boolean AUTO_ATTACK = true;
    private boolean AUTO_UNCONSCIOUS = true;
    private InitTable initTable;
    private JTextPane logTextArea;
    private HTMLDocument logTextDocument;
    private HTMLEditorKit kit;
    private ActorDetailsPanel detailsPanel;
    private GroupManager groupManager;
    private CriticalTablesDialog criticalTables;
    private Properties propertyBag = new Properties();
    private JLabel roundCounter;
    private JSplitPane jSplitPaneVertical;
    private JSplitPane jSplitPaneHorizontal;
    private UndoManager undoManager;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private Integer round = 0;

    private static void createAndShowGUI() {
        GITApp mainApp = new GITApp("GURPS Initiative Tool");
        mainApp.setDefaultCloseOperation(0);
        mainApp.loadProperties();
        mainApp.addComponentsToPane();
        if (Boolean.valueOf(mainApp.propertyBag.getProperty("GITApp.Manager.visible")).booleanValue()) {
            mainApp.groupManager.setVisible(true);
        }
        mainApp.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITApp.createAndShowGUI();
            }
        });
    }

    public GITApp(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("resetRound".equals(e.getActionCommand())) {
            this.round = 0;
            this.refreshRoundText();
            this.initTable.resetEncounter();
        } else if ("openGroupManager".equals(e.getActionCommand())) {
            this.validateOnScreen(this.groupManager);
            this.groupManager.setVisible(true);
        } else if ("openCriticalTables".equals(e.getActionCommand())) {
            this.validateOnScreen(this.criticalTables);
            this.criticalTables.setVisible(true);
        } else if ("sizeColumns".equals(e.getActionCommand())) {
            this.initTable.autoSizeColumns();
        } else {
            System.out.println("GITApp: -W- Unknown action performed: " + e.getActionCommand());
        }
    }

    public void actorAttack() {
        Actor actor = this.initTable.getActiveActor();
        if (actor == null) {
            return;
        }
        this.addLogLine(actor.Attack());
    }

    @Override
    public void encounterLogMessageSent(EncounterLogEvent evt) {
        this.addLogLine(evt.logMsg);
    }

    public void addLogLine(String line) {
        this.addLogLine(line, true);
    }

    public void addLogLine(String line, boolean addRound) {
        if (this.round <= 0) {
            return;
        }
        try {
            String round = addRound ? "Round " + this.roundCounter.getText() + ": " : "";
            this.kit.insertHTML(this.logTextDocument, this.logTextDocument.getLength(), String.valueOf(round) + line, 0, 0, null);
        }
        catch (BadLocationException e) {
            System.out.println("-E- addLogLine: BadLocationException trying to add line: " + line);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("-E- addLogLine: IOException trying to add line: " + line);
            e.printStackTrace();
        }
        this.logTextArea.select(this.logTextDocument.getLength(), this.logTextDocument.getLength());
    }

    public void actorDefend() {
        System.out.println("GITApp: ActorDefend: start");
        Actor actor = this.initTable.getSelectedActor();
        if (actor == null) {
            return;
        }
        this.initTable.stopCellEditing();
        DefenseDialog defense = new DefenseDialog(actor, this, true);
        defense.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.y")));
        this.validateOnScreen(defense);
        defense.setVisible(true);
        if (defense.valid) {
            this.ProcessActorDefense(actor, defense);
            this.LogActorDefense(actor, defense);
            this.KnockdownStunningCheck(actor, defense);
        }
        this.propertyBag.setProperty("GITApp.defense.location.x", String.valueOf(defense.getLocation().x));
        this.propertyBag.setProperty("GITApp.defense.location.y", String.valueOf(defense.getLocation().y));
    }

    private void ProcessActorDefense(Actor actor, DefenseDialog defense) {
        actor.ShieldDamage += defense.shieldDamage;
        actor.Injury += defense.injury;
        this.initTable.setActorValue(actor, InitTableModel.columns.Fatigue, actor.Fatigue + defense.fatigue);
        switch (defense.defenseType) {
            case Parry: {
                ++actor.numParry;
                break;
            }
            case Block: {
                ++actor.numBlock;
            }
        }
        this.initTable.getActorTableModel().fireRefresh(actor);
    }

    private void KnockdownStunningCheck(Actor actor, DefenseDialog defense) {
        if (defense.cripplingInjury || defense.majorWound) {
            int effHT = actor.HT + defense.location.knockdownPenalty;
            int roll = DieRoller.roll3d6();
            int MoS = effHT - roll;
            String success = MoS < 0 ? "<b>failed</b>" : "succeeded";
            this.addLogLine("<b>" + actor.Name + "</b> Knockdown/Stunning check: rolled " + roll + " against " + effHT + " (" + success + " by " + Math.abs(MoS) + ")");
        }
    }

    private void LogActorDefense(Actor actor, DefenseDialog defense) {
        String resultType = defense.defenseResult == DefenseDialog.DefenseResult.CritSuccess ? "<b><font color=blue>critically</font></b>" : (defense.defenseResult == DefenseDialog.DefenseResult.Success ? "successfully" : (defense.defenseResult == DefenseDialog.DefenseResult.ShieldHit ? "partially" : "unsuccessfully"));
        String defenseDescription = "";
        switch (defense.defenseType) {
            case Parry: {
                defenseDescription = String.valueOf(resultType) + " parried blow.";
                break;
            }
            case Block: {
                defenseDescription = String.valueOf(resultType) + " blocked blow.";
                break;
            }
            case Dodge: {
                defenseDescription = String.valueOf(resultType) + " dodged blow.";
                break;
            }
            case None: {
                defenseDescription = "made no defense against blow.";
            }
        }
        String damageDescription = "";
        if (defense.injury != 0) {
            String knockdownstunningPenalty;
            damageDescription = " Sustained <b><font color=red>" + defense.injury + "</font></b> injury to the " + defense.location.description;
            String string = knockdownstunningPenalty = defense.location.knockdownPenalty != 0 ? " @ " + defense.location.knockdownPenalty : "";
            if (defense.cripplingInjury) {
                damageDescription = String.valueOf(damageDescription) + " <b>(crippling" + knockdownstunningPenalty + ")</br>";
            } else if (defense.majorWound) {
                damageDescription = String.valueOf(damageDescription) + " <b>(major" + knockdownstunningPenalty + ")</br>";
            }
            damageDescription = String.valueOf(damageDescription) + ".";
        } else if (defense.defenseResult == DefenseDialog.DefenseResult.ShieldHit || defense.defenseResult == DefenseDialog.DefenseResult.Failure) {
            damageDescription = " But took no damage.";
        }
        if (defense.shieldDamage != 0) {
            damageDescription = String.valueOf(damageDescription) + " <b>Shield damaged " + defense.shieldDamage + ".</b>";
        }
        this.addLogLine("<b>" + actor.Name + "</b> " + defenseDescription + damageDescription);
    }

    public boolean nextActor() {
        Actor actor = this.initTable.getActiveActor();
        if (actor != null && actor.Type == Actor.ActorType.Enemy) {
            if (this.AUTO_UNCONSCIOUS && actor.Injury >= actor.HP && (actor.State == Actor.ActorState.Active || actor.State == Actor.ActorState.Stunned)) {
                int penalty = (int)(-1.0 * (Math.floor((double)actor.Injury / (double)actor.HP) - 1.0));
                int result = DieRoller.roll3d6();
                String details = "(HT: " + actor.HT + ", penalty: " + penalty + ", roll: " + result + ")";
                if (result > actor.HT + penalty) {
                    this.addLogLine("<b>" + actor.Name + "</b> <b><font color=red>failed</font></b> consciousness roll " + details);
                    this.initTable.setActorValue(actor, InitTableModel.columns.State, (Object)Actor.ActorState.Unconscious);
                } else {
                    this.addLogLine("<b>" + actor.Name + "</b> passed consciousness roll " + details);
                }
            }
            if (this.AUTO_ATTACK && actor.State == Actor.ActorState.Active) {
                this.actorAttack();
            }
        }
        if (this.initTable.nextActor()) {
            this.round = this.round + 1;
            this.refreshRoundText();
            this.addLogLine("<b>** Round " + this.roundCounter.getText() + " **</b>", false);
            return true;
        }
        return false;
    }

    public void nextRound() {
        while (!this.nextActor()) {
        }
    }

    private void refreshRoundText() {
        this.roundCounter.setText(this.round.toString());
        int minimumWidth = this.roundCounter.getMinimumSize().width / 10 * 10;
        if (this.roundCounter.getMinimumSize().width + 1 != 0) {
            minimumWidth += 10;
        }
        this.roundCounter.setPreferredSize(new Dimension(minimumWidth, 20));
    }

    private void addComponentsToPane() {
        this.groupManager = new GroupManager(this.propertyBag);
        this.criticalTables = new CriticalTablesDialog((Frame)this, false);
        this.setDefaultProperties();
        JMenuBar menubar = new JMenuBar();
        JMenu menuFile = new JMenu("Edit");
        menuFile.setMnemonic(69);
        this.undoMenuItem = new JMenuItem("Undo", 85);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.getAccessibleContext().setAccessibleDescription("Undo the last reversible action");
        this.undoMenuItem.addActionListener(this);
        menuFile.add(this.undoMenuItem);
        this.redoMenuItem = new JMenuItem("Redo", 82);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.getAccessibleContext().setAccessibleDescription("Redo the last undone action");
        this.redoMenuItem.addActionListener(this);
        menuFile.add(this.redoMenuItem);
        JMenuItem menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cut.png"), "Cut"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/page_copy.png"), "Copy"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/paste_plain.png"), "Paste"));
        menuFile.add(menuItem);
        menubar.add(menuFile);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar("Encounter Control Toolbar");
        JButton button = new JButton();
        URL imageURL = GITApp.class.getResource("/resources/images/control_play_blue.png");
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, "Next Actor"));
        }
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Step to next actor (Alt+N)");
        AbstractAction action = new AbstractAction("nextActor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.nextActor();
            }
        };
        button.setMnemonic(78);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_fastforward_blue.png"), "Next Round"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Skip to the next round (Ctrl+N)");
        action = new AbstractAction("nextRound"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.nextRound();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control N"), "nextRound");
        button.getActionMap().put("nextRound", action);
        button.addActionListener(action);
        toolbar.add(button);
        JLabel label = new JLabel("Round:");
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        toolbar.add(label);
        label = new JLabel("0");
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        label.setPreferredSize(new Dimension(20, 20));
        this.roundCounter = label;
        toolbar.add(label);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_start_blue.png"), "Reset Encounter"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Reset the round counter (Alt+R)");
        button.setActionCommand("resetRound");
        button.setMnemonic(82);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/script_code.png"), "Auto-size columns"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Auto re-size the table columns to best fit (Alt+A)");
        button.setActionCommand("sizeColumns");
        button.setMnemonic(65);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/wrench_orange.png"), "Attack"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Active actor attacks (Ctrl+A)");
        action = new AbstractAction("actorAttack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.actorAttack();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control A"), "actorAttack");
        button.getActionMap().put("actorAttack", action);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/shield.png"), "Defend"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Selected actor defends (Ctrl+D)");
        action = new AbstractAction("actorDefend"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.actorDefend();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control D"), "actorDefend");
        button.getActionMap().put("actorDefend", action);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/tag_blue_add.png"), "Tag"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Add enemy tags (Ctrl+T)");
        action = new AbstractAction("tagActors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.initTable.getActorTableModel().autoTagActors();
                GITApp.this.initTable.autoSizeColumns();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control T"), "tagActors");
        button.getActionMap().put("tagActors", action);
        button.addActionListener(action);
        toolbar.add(button);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/table_error.png"), "Critical Tables"));
        button.setToolTipText("Open Critical Tables (Alt+C)");
        button.setActionCommand("openCriticalTables");
        button.setMnemonic(67);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/group.png"), "Group Manager"));
        button.setToolTipText("Manage Actor Groups (Alt+G)");
        button.setActionCommand("openGroupManager");
        button.setMnemonic(71);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.setRollover(true);
        this.getContentPane().add((Component)toolbar, "First");
        this.logTextArea = new JTextPane();
        this.logTextDocument = new HTMLDocument();
        this.kit = new HTMLEditorKit();
        this.logTextArea.setEditorKit(this.kit);
        this.logTextArea.setDocument(this.logTextDocument);
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Tahoma", 0, 11));
        this.initTable = new InitTable(true);
        this.initTable.getActorTableModel().addEncounterLogEventListener(this);
        JScrollPane tableScrollPane = new JScrollPane(this.initTable);
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        this.detailsPanel = new ActorDetailsPanel(this.initTable);
        JScrollPane actorDetailsPane = new JScrollPane(this.detailsPanel);
        actorDetailsPane.setMinimumSize(new Dimension(this.detailsPanel.getPreferredSize().width + 20, 0));
        this.jSplitPaneVertical = new JSplitPane(0, tableScrollPane, logScrollPane);
        this.jSplitPaneVertical.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitVertical.dividerLocation")));
        this.jSplitPaneVertical.setResizeWeight(0.8);
        this.jSplitPaneHorizontal = new JSplitPane(1, this.jSplitPaneVertical, actorDetailsPane);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.getContentPane().add((Component)this.jSplitPaneHorizontal, "Center");
        this.undoManager = new UndoManager();
        this.refreshUndoRedo();
        this.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.location.y")));
        this.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.size.height")));
        this.validateOnScreen(this);
        this.addWindowListener(new GITAppWindowListener());
    }

    private void loadProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            FileInputStream propIn = new FileInputStream(propertyFile);
            this.propertyBag.load(propIn);
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: loadProperties: File not found? " + e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("GITApp: loadProperties: Error reading file! " + e.toString());
            e.printStackTrace();
        }
    }

    private boolean saveProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            FileOutputStream propOut = new FileOutputStream(propertyFile);
            this.propertyBag.store(propOut, "GITApp Properties");
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: saveProperties: File not found? " + e.toString());
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("GITApp: saveProperties: Error writing to file! " + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("GITApp.Manager.visible")) {
            this.propertyBag.setProperty("GITApp.Manager.visible", "false");
        }
        if (!this.propertyBag.containsKey("GITApp.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", "460");
        }
        if (!this.propertyBag.containsKey("GITApp.splitVertical.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.location.x")) {
            this.propertyBag.setProperty("GITApp.location.x", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.location.y")) {
            this.propertyBag.setProperty("GITApp.location.y", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.size.width")) {
            this.propertyBag.setProperty("GITApp.size.width", "760");
        }
        if (!this.propertyBag.containsKey("GITApp.size.height")) {
            this.propertyBag.setProperty("GITApp.size.height", "480");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.x")) {
            this.propertyBag.setProperty("GITApp.defense.location.x", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.y")) {
            this.propertyBag.setProperty("GITApp.defense.location.y", "200");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("GITApp.Manager.visible", String.valueOf(this.groupManager.isVisible()));
        this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", String.valueOf(this.jSplitPaneVertical.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("GITApp.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("GITApp.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("GITApp.size.height", String.valueOf(this.getSize().height));
    }

    public void validateOnScreen(Component c) {
        Rectangle window = c.getBounds();
        Rectangle virtualscreen = new Rectangle();
        GraphicsDevice[] gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int j = 0;
        while (j < gs.length) {
            GraphicsConfiguration[] gc = gs[j].getConfigurations();
            int i = 0;
            while (i < gc.length) {
                virtualscreen = virtualscreen.union(gc[i].getBounds());
                ++i;
            }
            ++j;
        }
        if (!virtualscreen.contains(window)) {
            if (window.x < virtualscreen.x) {
                window.translate(virtualscreen.x - window.x, 0);
            }
            if (window.y < virtualscreen.y) {
                window.translate(0, virtualscreen.y - window.y);
            }
            if (window.height > virtualscreen.height) {
                window.height = virtualscreen.height;
            }
            if (window.width > virtualscreen.width) {
                window.width = virtualscreen.width;
            }
            if (window.x + window.width > virtualscreen.x + virtualscreen.width) {
                window.translate(virtualscreen.x + virtualscreen.width - (window.x + window.width), 0);
            }
            if (window.y + window.height > virtualscreen.y + virtualscreen.height) {
                window.translate(0, virtualscreen.y + virtualscreen.height - (window.y + window.height));
            }
        }
        c.setLocation(window.x, window.y);
    }

    public void refreshUndoRedo() {
        this.undoMenuItem.setText(this.undoManager.getUndoPresentationName());
        this.undoMenuItem.setEnabled(this.undoManager.canUndo());
        this.redoMenuItem.setText(this.undoManager.getRedoPresentationName());
        this.redoMenuItem.setEnabled(this.undoManager.canRedo());
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    class GITAppWindowListener
    implements WindowListener {
        GITAppWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            GITApp.this.updateProperties();
            GITApp.this.groupManager.updateProperties();
            if (GITApp.this.groupManager.querySaveChanges() && GITApp.this.saveProperties()) {
                System.exit(0);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }
}

