/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.data.Actor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class InitTable
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private JPopupMenu popupMenu;
    private InitTableModel tableModel;
    private boolean isInitTable;

    public InitTable(boolean isInitTable) {
        super(new InitTableModel());
        this.isInitTable = isInitTable;
        this.tableModel = (InitTableModel)this.dataModel;
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            block19: {
                System.out.println("InitTable: Received action command " + e.getActionCommand());
                if (!"Delete".equals(e.getActionCommand())) break block19;
                this.stopCellEditing();
                int[] rows = this.getSelectedRows();
                int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete these rows?", "Confirm Row Delete", 2);
                if (result != 0) break block20;
                int i = rows.length - 1;
                while (i >= 0) {
                    System.out.println("InitTable: Deleting row: " + rows[i]);
                    this.tableModel.removeActor(rows[i]);
                    --i;
                }
                break block20;
            }
            if ("Reset".equals(e.getActionCommand())) {
                this.stopCellEditing();
                int[] rows = this.getSelectedRows();
                System.out.println("InitTable: Resetting actor. Row: " + rows[0] + ", Actor: " + this.tableModel.getActor((int)rows[0]).Name);
                int i = 0;
                while (i < rows.length) {
                    Actor actor = this.tableModel.getActor(rows[i]);
                    actor.Reset();
                    this.tableModel.fireRefresh(actor);
                    ++i;
                }
            } else if ("Set Active".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                System.out.println("InitTable: Setting active actor. Row: " + rows[0] + ", Actor: " + this.tableModel.getActor((int)rows[0]).Name);
                this.tableModel.setActiveRow(rows[0]);
                int i = 0;
                while (i < rows.length) {
                    this.tableModel.setValueAt("Active", rows[i], InitTableModel.columns.State.ordinal());
                    ++i;
                }
            } else if ("Tag".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                System.out.println("InitTable: Tagging actor. Row: " + rows[0] + ", Actor: " + this.tableModel.getActor((int)rows[0]).Name);
                int i = 0;
                while (i < rows.length) {
                    this.tableModel.tagActor(this.tableModel.getActor(rows[i]));
                    ++i;
                }
            } else if ("Remove Tag".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                System.out.println("InitTable: Un-tagging actor. Row: " + rows[0] + ", Actor: " + this.tableModel.getActor((int)rows[0]).Name);
                int i = 0;
                while (i < rows.length) {
                    this.tableModel.removeTag(this.tableModel.getActor(rows[i]));
                    ++i;
                }
            } else {
                int i;
                int[] rows;
                Enum[] enumArray = Actor.ActorState.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor.ActorState s = enumArray[n2];
                    if (s.toString().equals(e.getActionCommand())) {
                        this.stopCellEditing();
                        rows = this.getSelectedRows();
                        i = 0;
                        while (i < rows.length) {
                            this.tableModel.setValueAt(s.toString(), rows[i], InitTableModel.columns.State.ordinal());
                            ++i;
                        }
                    }
                    ++n2;
                }
                enumArray = Actor.ActorType.values();
                n = enumArray.length;
                n2 = 0;
                while (n2 < n) {
                    Enum t = enumArray[n2];
                    if (t.toString().equals(e.getActionCommand())) {
                        this.stopCellEditing();
                        rows = this.getSelectedRows();
                        i = 0;
                        while (i < rows.length) {
                            this.tableModel.setValueAt(t.toString(), rows[i], InitTableModel.columns.Type.ordinal());
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void autoSizeColumns() {
        System.out.println("autoSizeColumns: starting.");
        TableColumn column = null;
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int j = 0;
            while (j < this.getRowCount()) {
                renderer = this.getCellRenderer(j, i);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(j, i), false, false, j, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++j;
            }
            column.setPreferredWidth(width);
            if (this.isInitTable && i == 0) {
                column.setMaxWidth(width);
                column.setMinWidth(width);
            }
            ++i;
        }
    }

    private JMenuItem createMenuItem(String text, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void initialize() {
        this.setDefaultRenderer(Object.class, new InitTableCellRenderer());
        this.setDefaultRenderer(new Integer(0).getClass(), new InitTableCellRenderer());
        this.setDefaultEditor(String.class, new InitTableTextCellEditor());
        this.setDefaultEditor(new Integer(0).getClass(), new InitTableIntegerCellEditor());
        this.setTransferHandler(new InitTableTransferHandler("name"));
        this.setPreferredScrollableViewportSize(new Dimension(800, 270));
        this.setFillsViewportHeight(true);
        this.setSelectionMode(2);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setSurrendersFocusOnKeystroke(false);
        this.getColumnModel().getColumn(InitTableModel.columns.Act.ordinal()).setResizable(false);
        JComboBox<Actor.ActorState> initTableStateEditor = new JComboBox<Actor.ActorState>();
        Actor.ActorState[] actorStateArray = Actor.ActorState.values();
        int n = actorStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor.ActorState a = actorStateArray[n2];
            initTableStateEditor.addItem(a);
            ++n2;
        }
        this.getColumnModel().getColumn(InitTableModel.columns.State.ordinal()).setCellEditor(new InitTableComboCellEditor(initTableStateEditor));
        ((DefaultCellEditor)this.getColumnModel().getColumn(InitTableModel.columns.State.ordinal()).getCellEditor()).setClickCountToStart(2);
        JComboBox<Actor.ActorType> initTableTypeEditor = new JComboBox<Actor.ActorType>();
        Actor.ActorType[] actorTypeArray = Actor.ActorType.values();
        int n3 = actorTypeArray.length;
        n = 0;
        while (n < n3) {
            Actor.ActorType a = actorTypeArray[n];
            initTableTypeEditor.addItem(a);
            ++n;
        }
        this.getColumnModel().getColumn(InitTableModel.columns.Type.ordinal()).setCellEditor(new InitTableComboCellEditor(initTableTypeEditor));
        ((DefaultCellEditor)this.getColumnModel().getColumn(InitTableModel.columns.Type.ordinal()).getCellEditor()).setClickCountToStart(2);
        this.getColumnModel().getColumn(InitTableModel.columns.Damage.ordinal()).setCellEditor(new InitTableDamageCellEditor());
        this.getColumnModel().getColumn(InitTableModel.columns.Fatigue.ordinal()).setCellEditor(new InitTableDamageCellEditor());
        this.popupMenu = new JPopupMenu();
        JMenu menuFile = new JMenu("Set Status");
        menuFile.setMnemonic(83);
        menuFile.add(this.createMenuItem("Active", 65));
        menuFile.add(this.createMenuItem("Waiting", 87));
        menuFile.add(this.createMenuItem("Stunned", 83));
        menuFile.add(this.createMenuItem("Disabled", 68));
        menuFile.add(this.createMenuItem("Unconscious", 85));
        menuFile.add(this.createMenuItem("Dead", 69));
        this.popupMenu.add(menuFile);
        menuFile = new JMenu("Set Type");
        menuFile.setMnemonic(84);
        menuFile.add(this.createMenuItem("PC", 67));
        menuFile.add(this.createMenuItem("Ally", 65));
        menuFile.add(this.createMenuItem("Enemy", 69));
        menuFile.add(this.createMenuItem("Neutral", 78));
        menuFile.add(this.createMenuItem("Special", 83));
        this.popupMenu.add(menuFile);
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Set Active", 65));
        }
        this.popupMenu.add(this.createMenuItem("Reset", 82));
        this.popupMenu.add(this.createMenuItem("Delete", 127));
        this.popupMenu.add(this.createMenuItem("Tag", 84));
        this.popupMenu.add(this.createMenuItem("Remove Tag", 86));
        MousePopupListener popupListener = new MousePopupListener();
        this.addMouseListener(popupListener);
        this.getTableHeader().addMouseListener(popupListener);
        if (!this.isInitTable) {
            this.getColumnModel().removeColumn(this.getColumnModel().getColumn(InitTableModel.columns.Act.ordinal()));
        }
        this.autoSizeColumns();
    }

    public boolean isInitTable() {
        return this.isInitTable;
    }

    public boolean nextActor() {
        return this.tableModel.nextActor();
    }

    public InitTableModel getActorTableModel() {
        return this.tableModel;
    }

    public Actor getActiveActor() {
        return this.tableModel.getActiveActor();
    }

    public Actor getSelectedActor() {
        int index = this.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.tableModel.getActor(index);
    }

    @Override
    public int[] getSelectedRows() {
        int[] rows = super.getSelectedRows();
        if (rows.length > 0 && rows[rows.length - 1] == this.getRowCount() - 1) {
            if (rows.length == 1) {
                return new int[0];
            }
            int[] newrows = new int[rows.length - 1];
            System.arraycopy(rows, 0, newrows, 0, newrows.length);
            return newrows;
        }
        return rows;
    }

    public void setActorValue(Actor actor, InitTableModel.columns field, Object newValue) {
        this.tableModel.setValueAt(newValue, this.tableModel.getActorRows(actor)[0], field.ordinal());
    }

    public void resetEncounter() {
        this.tableModel.resetEncounter();
    }

    public void stopCellEditing() {
        if (this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    public static void formatComponentAlignment(JLabel c, Actor a, InitTableModel.columns col) {
        c.setHorizontalAlignment(2);
        c.setHorizontalTextPosition(10);
        switch (a.State) {
            case Waiting: {
                c.setHorizontalAlignment(4);
            }
        }
        if (col == InitTableModel.columns.Act) {
            c.setHorizontalAlignment(4);
        }
    }

    public static void formatComponentAlignment(JTextField c, Actor a) {
        c.setHorizontalAlignment(2);
        switch (a.State) {
            case Waiting: {
                c.setHorizontalAlignment(4);
            }
        }
    }

    public static void formatComponentColor(JComponent c, Actor a, boolean isSelected, InitTableModel.columns col) {
        if (col == InitTableModel.columns.Damage || col == InitTableModel.columns.Fatigue) {
            c.setForeground(new Color(220, 0, 0));
        } else {
            c.setForeground(new Color(0, 0, 0));
        }
        if (isSelected) {
            switch (a.Type) {
                case PC: {
                    c.setBackground(new Color(128, 255, 128));
                    break;
                }
                case Ally: {
                    c.setBackground(new Color(128, 128, 255));
                    break;
                }
                case Enemy: {
                    c.setBackground(new Color(255, 128, 128));
                    break;
                }
                case Neutral: {
                    c.setBackground(new Color(128, 128, 128));
                    break;
                }
                case Special: {
                    c.setBackground(new Color(255, 128, 255));
                }
            }
        } else {
            switch (a.Type) {
                case PC: {
                    c.setBackground(new Color(200, 255, 200));
                    break;
                }
                case Ally: {
                    c.setBackground(new Color(200, 200, 255));
                    break;
                }
                case Enemy: {
                    c.setBackground(new Color(255, 200, 200));
                    break;
                }
                case Neutral: {
                    c.setBackground(new Color(200, 200, 200));
                    break;
                }
                case Special: {
                    c.setBackground(new Color(255, 200, 255));
                }
            }
        }
        switch (a.State) {
            case Unconscious: 
            case Dead: {
                c.setForeground(new Color(128, 128, 128));
            }
        }
    }

    class InitTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        InitTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                c.setIcon(new ImageIcon());
                if (col == InitTableModel.columns.Name) {
                    c.setText("new...");
                }
                return c;
            }
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            if (col == InitTableModel.columns.Act && InitTable.this.tableModel.getActiveActorIndex() == row) {
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/go.png"), "Current Actor"));
            } else if ((col == InitTableModel.columns.Move || col == InitTableModel.columns.Dodge) && a.Injury > 2 * a.HP / 3 && a.Fatigue > 2 * a.FP / 3) {
                int currentValue = Integer.parseInt(c.getText());
                int newValue = (int)Math.ceil((double)currentValue / 4.0);
                c.setText("<html>" + c.getText() + " <strong>(" + newValue + ")</strong></html>");
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/exclamation.png"), "Greatly reduced state"));
            } else if (!(col != InitTableModel.columns.Move && col != InitTableModel.columns.Dodge || a.Injury <= 2 * a.HP / 3 && a.Fatigue <= 2 * a.FP / 3)) {
                int currentValue = Integer.parseInt(c.getText());
                int newValue = (int)Math.ceil((double)currentValue / 2.0);
                c.setText("<html>" + c.getText() + " <strong>(" + newValue + ")</strong></html>");
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Reduced state"));
            } else if (col == InitTableModel.columns.HT && a.Injury >= a.HP) {
                int penalty = (int)(-1.0 * (Math.floor((double)a.Injury / (double)a.HP) - 1.0));
                if (penalty < 0) {
                    c.setText("<html>" + c.getText() + " <strong>(" + penalty + ")</strong></html>");
                }
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Must check to stay conscious"));
            } else {
                c.setIcon(new ImageIcon());
            }
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a, col);
            return c;
        }
    }

    class InitTableComboCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public InitTableComboCellEditor(JComboBox<?> comboBox) {
            super(comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ((JComboBox)c).setSelectedItem(value.toString());
            return c;
        }
    }

    class InitTableDamageCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private static final boolean DEBUG = true;

        public InitTableDamageCellEditor() {
            super(new JTextField());
            DamageDocumentFilter df = new DamageDocumentFilter();
            JTextField tf = (JTextField)this.getComponent();
            tf.addFocusListener(df);
            ((AbstractDocument)tf.getDocument()).setDocumentFilter(df);
        }

        @Override
        public Object getCellEditorValue() {
            JTextField tf = (JTextField)this.getComponent();
            try {
                Integer value = new Integer(tf.getText());
                return value;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String text = tf.getText();
            Pattern pattern = Pattern.compile("^(-?\\d+)([\\+-])(\\d+)(.*)$");
            Matcher matcher = pattern.matcher(text);
            while (matcher.matches()) {
                Integer first = new Integer(matcher.group(1));
                String operator = matcher.group(2);
                Integer second = new Integer(matcher.group(3));
                Integer result = operator.equals("+") ? Integer.valueOf(first + second) : Integer.valueOf(first - second);
                text = matcher.group(4);
                System.out.println("InitTableDamageCellEditor: Calculating damage: " + first + " : " + operator + " : " + second + " = " + result + " (" + text + ").");
                text = result + text;
                matcher = pattern.matcher(text);
            }
            try {
                new Integer(text);
                tf.setText(text);
                return super.stopCellEditing();
            }
            catch (NumberFormatException e) {
                tf.setBorder(new LineBorder(new Color(220, 0, 0)));
                return false;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            c.setBorder(new LineBorder(new Color(255, 255, 255)));
            return c;
        }

        private class DamageDocumentFilter
        extends DocumentFilter
        implements FocusListener {
            boolean startingNew = true;
            boolean firstEdit = true;
            boolean hasFocus = false;

            private DamageDocumentFilter() {
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offs, int length) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Remove: offs: " + offs + ", len:" + length + ".");
                this.startingNew = false;
                super.remove(fb, offs, length);
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Insert:" + str + ".");
                if (str.matches("[\\d\\+-]+")) {
                    super.insertString(fb, offs, str, a);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Replace: '" + str + "', Offs=" + offs + ", Length=" + length + ".");
                if (str.matches("[\\d\\+-]+")) {
                    if (this.hasFocus || this.firstEdit || length > 0) {
                        this.firstEdit = false;
                        this.startingNew = true;
                        super.replace(fb, offs, length, str, a);
                    } else if (this.startingNew && str.matches("\\d")) {
                        this.startingNew = false;
                        super.replace(fb, offs, 0, "+", null);
                        super.replace(fb, offs + 1, 0, str, a);
                    } else {
                        this.startingNew = false;
                        super.replace(fb, offs, 0, str, a);
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                this.hasFocus = true;
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: TextField focus gained.");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                this.hasFocus = false;
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: TextField focus lost.");
            }
        }
    }

    class InitTableIntegerCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public InitTableIntegerCellEditor() {
            super(new JTextField());
        }

        @Override
        public Object getCellEditorValue() {
            JTextField tf = (JTextField)this.getComponent();
            try {
                Integer value = new Integer(tf.getText());
                return value;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String text = tf.getText();
            try {
                new Integer(text);
                tf.setText(text);
                return super.stopCellEditing();
            }
            catch (NumberFormatException e) {
                tf.setBorder(new LineBorder(new Color(220, 0, 0)));
                return false;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (isSelected) {
                c.selectAll();
            }
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            c.setBorder(new LineBorder(new Color(255, 255, 255)));
            return c;
        }
    }

    class InitTableTextCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        private String actorName;

        public InitTableTextCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.editorComponent.addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            this.actorName = a.Name;
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            return c;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            System.out.println("InitTable: Focus gained on " + evt.toString());
            if (!InitTable.this.getSelectedActor().Name.equals(this.actorName)) {
                JTextField t = (JTextField)evt.getComponent();
                this.actorName = InitTable.this.getSelectedActor().Name;
                t.setText(this.actorName);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            System.out.println("InitTable: Focus lost on " + evt.toString());
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
            this.checkResize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger() & InitTable.this.getSelectedRows().length > 0) {
                InitTable.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void checkResize(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Cursor currentCursor = InitTable.this.getTableHeader().getCursor();
                System.out.println("MouseClickListener: checkResize: double-click detected. Type is " + currentCursor.getType() + " (" + currentCursor.toString() + ")");
                if (currentCursor.getType() == 11) {
                    InitTable.this.autoSizeColumns();
                    System.out.println("MouseClickListener: checkResize: auto-sizing columns.");
                }
            }
        }
    }
}

