/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogEventListener;
import gurpsinittool.util.EncounterLogEventSource;
import gurpsinittool.util.FileChangeEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class InitTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String[] columnNames = new String[]{"Act", "Name", "Move", "Dodge", "HT", "HP", "Damage", "FP", "Fatigue", "State", "Type"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class, String.class};
    private static int numColumns = 11;
    Actor newActor = new Actor("", Actor.ActorState.Active, Actor.ActorType.Enemy);
    private ArrayList<Actor> actorList = new ArrayList<Actor>(Arrays.asList(new Actor(this.newActor)));
    private int activeActor = -1;
    public static Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
    public static int flagMaxNum = 6;
    protected EncounterLogEventSource encounterLogEventSource = new EncounterLogEventSource();
    protected CleanFileChangeEventSource cleanFileChangeEventSource = new CleanFileChangeEventSource(this);

    public void addActor(Actor source, int dest) {
        if (dest > this.actorList.size() - 1) {
            dest = this.actorList.size() - 1;
        } else if (dest < 0) {
            dest = 0;
        }
        if (dest <= this.activeActor) {
            ++this.activeActor;
        }
        this.actorList.add(dest, source);
        this.setDirty();
        this.fireTableRowsInserted(dest, dest);
    }

    public void fireRefresh(Actor actor) {
        int[] rows = this.getActorRows(actor);
        int i = 0;
        while (i < rows.length) {
            this.setDirty();
            this.fireTableRowsUpdated(rows[i], rows[i]);
            ++i;
        }
    }

    public int getActiveActorIndex() {
        return this.activeActor;
    }

    public Actor getActiveActor() {
        if (this.activeActor < 0) {
            return null;
        }
        return this.getActor(this.activeActor);
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return actor.Name;
            }
            case Move: {
                return actor.Move;
            }
            case Dodge: {
                return actor.Dodge;
            }
            case HT: {
                return actor.HT;
            }
            case HP: {
                return actor.HP;
            }
            case Damage: {
                return actor.Injury;
            }
            case FP: {
                return actor.FP;
            }
            case Fatigue: {
                return actor.Fatigue;
            }
            case State: {
                return actor.State;
            }
            case Type: {
                return actor.Type;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("ActorTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        switch (columns.values()[col]) {
            case State: {
                value = Actor.ActorState.valueOf(value.toString());
                break;
            }
            case Type: {
                value = Actor.ActorType.valueOf(value.toString());
            }
        }
        if (this.getValueAt(row, col).equals(value)) {
            System.out.println("ActorTableModel: setValueAt: values are identical. Exiting.");
            return;
        }
        if (row == this.actorList.size() - 1) {
            this.actorList.add(new Actor(this.newActor));
            this.setDirty();
            this.fireTableRowsInserted(row + 1, row + 1);
        }
        Actor a = this.actorList.get(row);
        switch (columns.values()[col]) {
            case Name: {
                a.Name = (String)value;
                break;
            }
            case Move: {
                a.Move = (Integer)value;
                break;
            }
            case Dodge: {
                a.Dodge = (Integer)value;
                break;
            }
            case HT: {
                a.HT = (Integer)value;
                break;
            }
            case HP: {
                a.HP = (Integer)value;
                break;
            }
            case Damage: {
                int newValue = (Integer)value;
                int diff = a.Injury - newValue;
                if (diff < 0) {
                    this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> took <b><font color=red>" + -1 * diff + "</font></b> damage (now " + (a.HP - newValue) + " HP)."));
                } else {
                    this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> healed <b><font color=blue>" + diff + "</font></b> (now " + (a.HP - newValue) + " HP)."));
                }
                a.Injury = newValue;
                break;
            }
            case FP: {
                a.FP = (Integer)value;
                break;
            }
            case Fatigue: {
                int newValue = (Integer)value;
                int diff = a.Fatigue - newValue;
                if (diff < 0) {
                    this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> lost <b>" + -1 * diff + "</b> fatigue (now " + (a.FP - newValue) + " FP)."));
                } else {
                    this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> recoverd <b>" + diff + "</b> fatigue (now " + (a.FP - newValue) + " FP)."));
                }
                a.Fatigue = newValue;
                break;
            }
            case State: {
                Actor.ActorState newState = (Actor.ActorState)((Object)value);
                this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> status changed to <b>" + (Object)((Object)newState) + "</b>"));
                a.State = newState;
                break;
            }
            case Type: {
                Actor.ActorType newType = (Actor.ActorType)((Object)value);
                this.encounterLogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, "<b>" + a.Name + "</b> type changed to <b>" + (Object)((Object)newType) + "</b>"));
                a.Type = newType;
            }
        }
        this.setDirty();
        int[] rows = this.getActorRows(a);
        int i = 0;
        while (i < rows.length) {
            this.fireTableRowsUpdated(rows[i], rows[i]);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (columns.values()[col]) {
            case Act: {
                return false;
            }
        }
        return true;
    }

    public boolean nextActor() {
        this.setDirty();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        boolean isNewRound = this.nextActorInternal();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        return isNewRound;
    }

    protected boolean nextActorInternal() {
        boolean isNewRound = this.activeActor == -1;
        do {
            ++this.activeActor;
            if (this.activeActor >= this.actorList.size() - 1) {
                this.activeActor = 0;
                if (isNewRound) {
                    this.activeActor = -1;
                    return true;
                }
                isNewRound = true;
            }
            this.getActiveActor().NextTurn();
        } while (this.actorList.get((int)this.activeActor).State != Actor.ActorState.Active & this.actorList.get((int)this.activeActor).State != Actor.ActorState.Disabled & this.actorList.get((int)this.activeActor).State != Actor.ActorState.Stunned);
        return isNewRound;
    }

    public void removeActor(int row) {
        this.actorList.remove(row);
        if (row < this.activeActor) {
            --this.activeActor;
        } else if (row == this.activeActor) {
            --this.activeActor;
            this.nextActor();
        }
        this.setDirty();
        this.fireTableRowsDeleted(row, row);
    }

    public void removeActor(Actor actor) {
        while (this.actorList.contains(actor)) {
            int row = this.actorList.indexOf(actor);
            this.removeActor(row);
        }
    }

    public void resetEncounter() {
        this.setDirty();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
            this.activeActor = -1;
        }
    }

    public void setActorList(ArrayList<Actor> actorList) {
        this.fireTableRowsDeleted(0, this.getRowCount());
        this.actorList = actorList == null ? new ArrayList<Actor>(Arrays.asList(new Actor(this.newActor))) : actorList;
        this.fireTableDataChanged();
    }

    public void setActiveRow(int row) {
        if (row > this.getRowCount() - 2) {
            throw new IndexOutOfBoundsException("Specified row is not an actor");
        }
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        this.activeActor = row;
        this.setValueAt(Actor.ActorState.Active.toString(), row, columns.State.ordinal());
        this.setDirty();
        this.fireTableCellUpdated(this.activeActor, 0);
    }

    public void autoTagActors() {
        HashSet<String> tags = this.catalogTags(true);
        int i = 0;
        while (i < this.actorList.size() - 1) {
            Actor a = this.actorList.get(i);
            if (a.Type == Actor.ActorType.Enemy && a.State != Actor.ActorState.Unconscious && a.State != Actor.ActorState.Dead && a.State != Actor.ActorState.Waiting) {
                this.tagActor(a, tags);
            }
            ++i;
        }
    }

    public void removeTag(Actor actor) {
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        Matcher matcher = nameTag.matcher(actor.Name);
        if (matcher.matches()) {
            String name;
            actor.Name = name = matcher.group(1);
            this.fireRefresh(actor);
        }
    }

    public void tagActor(Actor actor) {
        this.tagActor(actor, this.catalogTags(false));
    }

    public void tagActor(Actor actor, HashSet<String> tags) {
        if (!nameTag.matcher(actor.Name).matches()) {
            String tag = InitTableModel.getNextTag(tags);
            System.out.println("InitTableModel:tagActor: Tagging actor " + actor.Name + " with " + "[" + tag + "]");
            actor.Name = String.valueOf(actor.Name) + " [" + tag + "]";
            tags.add(tag);
            this.fireRefresh(actor);
        }
    }

    public HashSet<String> catalogTags(boolean clean) {
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        HashSet<String> tags = new HashSet<String>();
        int i = 0;
        while (i < this.actorList.size() - 1) {
            Actor a = this.actorList.get(i);
            System.out.println("catalogTags: Cataloging actor: " + a.Name);
            Matcher matcher = nameTag.matcher(a.Name);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String tag = matcher.group(2);
                if (clean && a.Type == Actor.ActorType.Enemy && (a.State == Actor.ActorState.Unconscious || a.State == Actor.ActorState.Dead)) {
                    System.out.println("catalogTags: cleaning tag: " + tag);
                    a.Name = name;
                    this.fireRefresh(a);
                } else {
                    if (tags.contains(tag)) {
                        System.out.println("-W- InitTableModel::catalogTags: Duplicate tag detected! " + tag);
                    }
                    tags.add(tag);
                }
            }
            ++i;
        }
        return tags;
    }

    private static String getNextTag(HashSet<String> tags) {
        flagColors[] flagColorsArray = flagColors.values();
        int n = flagColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            flagColors color = flagColorsArray[n2];
            int i = 1;
            while (i <= flagMaxNum) {
                String tag = String.valueOf(color.toString()) + i;
                if (!tags.contains(tag)) {
                    return tag;
                }
                ++i;
            }
            ++n2;
        }
        System.out.println("-W- InitTableModel:getNextTag: no free tags!");
        return "S99";
    }

    public void addEncounterLogEventListener(EncounterLogEventListener listener) {
        this.encounterLogEventSource.addEncounterLogEventListener(listener);
    }

    public void removeEncounterLogEventListener(EncounterLogEventListener listener) {
        this.encounterLogEventSource.removeEncounterLogEventListener(listener);
    }

    public boolean isClean() {
        return this.cleanFileChangeEventSource.isClean();
    }

    public void setClean() {
        this.cleanFileChangeEventSource.setClean();
    }

    public void setDirty() {
        this.cleanFileChangeEventSource.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.removeFileChangeEventListener(listener);
    }

    public static enum columns {
        Act,
        Name,
        Move,
        Dodge,
        HT,
        HP,
        Damage,
        FP,
        Fatigue,
        State,
        Type;

    }

    public static enum flagColors {
        R,
        B;

    }
}

