/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Attack;
import gurpsinittool.data.CriticalTables;
import gurpsinittool.data.Damage;
import gurpsinittool.util.DieRoller;
import java.io.Serializable;
import java.util.ArrayList;

public class Actor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String Name;
    public ActorState State;
    public ActorType Type;
    public String Notes;
    public int HT;
    public int HP;
    public int Injury;
    public int FP;
    public int Fatigue;
    public int Move;
    public int Parry;
    public int Block;
    public int Dodge;
    public int DR;
    public int DB;
    public int ShieldDR;
    public int ShieldHP;
    public int ShieldDamage = 0;
    public int numParry = 0;
    public int numBlock = 0;
    public int DefaultAttack = 0;
    public ArrayList<Attack> Attacks;

    public Actor(String name, ActorState state, ActorType type, int ht, int hp, int damage, int fp, int fatigue, int move, int parry, int block, int dodge, int dr, int db, int shield_dr, int shield_hp, int default_attack) {
        this.Name = name;
        this.State = state;
        this.Type = type;
        this.HP = hp;
        this.HT = ht;
        this.Injury = damage;
        this.FP = fp;
        this.Fatigue = fatigue;
        this.Move = move;
        this.Parry = parry;
        this.Block = block;
        this.Dodge = dodge;
        this.DR = dr;
        this.DB = db;
        this.ShieldDR = shield_dr;
        this.ShieldHP = shield_hp;
        this.DefaultAttack = default_attack;
        this.Attacks = new ArrayList();
    }

    public Actor(String name, ActorState state, ActorType type) {
        this(name, state, type, 10, 10, 0, 10, 0, 5, 9, 9, 8, 0, 2, 4, 20, 0);
    }

    public Actor(Actor anActor) {
        this(anActor.Name, anActor.State, anActor.Type, anActor.HT, anActor.HP, anActor.Injury, anActor.FP, anActor.Fatigue, anActor.Move, anActor.Parry, anActor.Block, anActor.Dodge, anActor.DR, anActor.DB, anActor.ShieldDR, anActor.ShieldHP, anActor.DefaultAttack);
        int i = 0;
        while (i < anActor.Attacks.size()) {
            this.Attacks.add(anActor.Attacks.get(i));
            ++i;
        }
    }

    public void NextTurn() {
        this.numParry = 0;
        this.numBlock = 0;
    }

    public String Attack() {
        CriticalTables.Entry crit_result;
        String hit_miss;
        if (this.Attacks.size() < 1) {
            return "<i><font color=gray>" + this.Name + " has no attacks defined!</font></i>";
        }
        if (this.DefaultAttack < 0 || this.DefaultAttack >= this.Attacks.size()) {
            return "<i><font color=gray>" + this.Name + " has invalid default attack: " + this.DefaultAttack + "</font></i>";
        }
        Attack attack = this.Attacks.get(this.DefaultAttack);
        int roll = DieRoller.roll3d6();
        int margin = attack.Skill - roll;
        String crit_string = "";
        if (DieRoller.isCritFailure(roll, attack.Skill)) {
            hit_miss = "<b><font color=red>Critical miss</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_miss);
            crit_string = "<br/> <i><font color=gray><b>Critical Miss Table Result:</b>" + crit_result.notes + "</font></i>";
        } else if (DieRoller.isCritSuccess(roll, attack.Skill)) {
            hit_miss = "<b><font color=blue>Critical hit</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_hit);
            crit_string = "<br/> <i><font color=gray><b>Critical Hit Table Result:</b>" + crit_result.notes + "</font></i>";
        } else {
            hit_miss = DieRoller.isSuccess(roll, attack.Skill) ? "<b>hit</b>" : "miss";
        }
        Damage damage = Damage.ParseDamage(attack.Damage);
        if (attack.Unbalanced) {
            ++this.numParry;
        }
        String armorDivStr = "";
        if (damage.ArmorDivisor != 1.0) {
            armorDivStr = damage.ArmorDivisor == (double)((int)damage.ArmorDivisor) ? "(" + String.format("%d", (int)damage.ArmorDivisor) + ")" : "(" + String.format("%s", damage.ArmorDivisor) + ")";
        }
        return "<b> " + this.Name + "</b> attacks with " + attack.Name + ": " + hit_miss + " (" + roll + "/" + attack.Skill + "=" + margin + ") for damage <font color=red><b>" + damage.BasicDamage + armorDivStr + " " + (Object)((Object)damage.Type) + "</b></font> (" + attack.Damage + ")" + crit_string;
    }

    public void Reset() {
        this.State = ActorState.Active;
        this.Injury = 0;
        this.Fatigue = 0;
        this.numParry = 0;
        this.numBlock = 0;
        this.ShieldDamage = 0;
    }

    public static enum ActorState {
        Active,
        Waiting,
        Stunned,
        Disabled,
        Unconscious,
        Dead;

    }

    public static enum ActorType {
        PC,
        Enemy,
        Ally,
        Neutral,
        Special;

    }
}

