/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import gurpsinittool.util.DieRoller;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Damage {
    public int BasicDamage;
    public double ArmorDivisor;
    public DamageType Type;

    public Damage(int basic, DamageType type) {
        this(basic, 1.0, type);
    }

    public Damage(int basic, double divisor, DamageType type) {
        this.BasicDamage = basic;
        this.ArmorDivisor = divisor;
        this.Type = type;
    }

    public static Damage ParseDamage(String damage) throws ParseException {
        Pattern empty = Pattern.compile("^$");
        Pattern num = Pattern.compile("^(\\d+)$");
        Pattern numtype = Pattern.compile("^(\\d+) ([^\\s]+)$");
        Pattern numdivtype = Pattern.compile("^(\\d+)\\(([\\d\\.]+)\\) ([^\\s]+)$");
        Pattern dicedivtype = Pattern.compile("^(\\d+)d[+]?([-]?\\d+)?\\s?\\(([\\d\\.]+)\\)\\s+([^\\d]+)$");
        Pattern dicetype = Pattern.compile("^(\\d+)d[+]?([-]?\\d+)?\\s+([^\\d]+)$");
        Matcher matcher = empty.matcher(damage);
        if (matcher.matches()) {
            return new Damage(0, DamageType.cr);
        }
        matcher = num.matcher(damage);
        if (matcher.matches()) {
            return new Damage(Integer.parseInt(matcher.group(1)), DamageType.cut);
        }
        matcher = numtype.matcher(damage);
        if (matcher.matches()) {
            return new Damage(Integer.parseInt(matcher.group(1)), Damage.ParseType(matcher.group(2)));
        }
        matcher = numdivtype.matcher(damage);
        if (matcher.matches()) {
            return new Damage(Integer.parseInt(matcher.group(1)), Double.parseDouble(matcher.group(2)), Damage.ParseType(matcher.group(3)));
        }
        matcher = dicedivtype.matcher(damage);
        if (matcher.matches()) {
            int dice = Integer.parseInt(matcher.group(1));
            int adds = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
            return new Damage(DieRoller.rollDiceAdds(dice, adds), Double.parseDouble(matcher.group(3)), Damage.ParseType(matcher.group(4)));
        }
        matcher = dicetype.matcher(damage);
        if (matcher.matches()) {
            int dice = Integer.parseInt(matcher.group(1));
            int adds = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
            return new Damage(DieRoller.rollDiceAdds(dice, adds), Damage.ParseType(matcher.group(3)));
        }
        System.out.println("-E- Damage:ParseDamage: unable to parse string! " + damage);
        throw new ParseException("ParseDamage: Unable to parse string: " + damage, 0);
    }

    public double DamageMultiplier() {
        return Damage.DamageMultiplier(this.Type);
    }

    public double DamageMultiplierHomogenous() {
        return Damage.DamageMultiplierHomogenous(this.Type);
    }

    public static DamageType ParseType(String type) throws ParseException {
        type = type.replace('-', '_');
        type = type.replace('+', '4');
        try {
            return DamageType.valueOf(type);
        }
        catch (Exception e) {
            System.out.println("-E- ParseType: unable to parse string! " + type);
            throw new ParseException("ParseType: Unable to parse string: " + type, 0);
        }
    }

    public static double DamageMultiplier(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case pi: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: 
            case pi4: {
                return 1.5;
            }
            case imp: 
            case pi44: {
                return 2.0;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        System.out.println("-E- Damage:DamageMultiplier: unhandled type! " + type.toString());
        return 0.0;
    }

    public static double DamageMultiplierHomogenous(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.1;
            }
            case pi: {
                return 0.2;
            }
            case pi4: {
                return 0.334;
            }
            case imp: 
            case pi44: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        System.out.println("-E- Damage:DamageMultiplierHomogenous: unhandled type! " + type.toString());
        return 0.0;
    }

    public static enum DamageType {
        aff,
        burn,
        cor,
        cr,
        cut,
        fat,
        imp,
        pi_,
        pi,
        pi4,
        pi44,
        spec,
        tbb,
        tox;

    }
}

