/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.app.AttackTableModel;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.Actor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

public class ActorDetailsPanel
extends JPanel
implements ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private InitTable initTable;
    private InitTableModel actorModel;
    private boolean actorLoaded = false;
    private int selectedActor = -1;
    private AttackTableModel attackTableModel;
    private JButton add_attack;
    private JPanel attacks;
    private JTable attacksTable;
    private JFormattedTextField block;
    private JFormattedTextField damage;
    private JFormattedTextField db;
    private JPanel debugPanel;
    private JButton default_attack;
    private JFormattedTextField dodge;
    private JFormattedTextField dr;
    private JFormattedTextField fatigue;
    private JFormattedTextField fp;
    private JFormattedTextField hp;
    private JFormattedTextField ht;
    private JFormattedTextField jFormattedTextField1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar jToolBar1;
    private JFormattedTextField move;
    private JTextField name;
    private JTextArea notes;
    private JLabel numBlockLabel;
    private JLabel numParryLabel;
    private JFormattedTextField parry;
    private JButton remove_attack;
    private JButton resizeAttackTable;
    private JLabel shieldDamageLabel;
    private JPanel shieldPanel;
    private JFormattedTextField shield_dr;
    private JFormattedTextField shield_hp;
    private JComboBox status;
    private JComboBox type;

    public ActorDetailsPanel(InitTable initTable) {
        this.initTable = initTable;
        this.actorModel = (InitTableModel)initTable.getModel();
        initTable.add(this);
        initTable.getSelectionModel().addListSelectionListener(this);
        this.actorModel.addTableModelListener(this);
        this.attackTableModel = new AttackTableModel(this.actorModel);
        this.initComponents();
        this.attacksTable.setDefaultRenderer(String.class, this.attackTableModel.new AttackTableModel.AttackTableCellRenderer());
        this.attacksTable.setDefaultRenderer(Integer.class, this.attackTableModel.new AttackTableModel.AttackTableCellRenderer());
        this.notes.getDocument().addDocumentListener(new ActorTextDocumentListener(textListenField.Notes));
        this.disablePanel();
    }

    private void initComponents() {
        this.jFormattedTextField1 = new JFormattedTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.attacks = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.add_attack = new JButton();
        this.remove_attack = new JButton();
        this.default_attack = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.resizeAttackTable = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.attacksTable = new JTable();
        this.status = new JComboBox();
        this.type = new JComboBox();
        this.jLabel7 = new JLabel();
        this.hp = new JFormattedTextField();
        this.damage = new JFormattedTextField();
        this.ht = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.notes = new JTextArea();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.fp = new JFormattedTextField();
        this.move = new JFormattedTextField();
        this.fatigue = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.parry = new JFormattedTextField();
        this.name = new JTextField();
        this.jLabel11 = new JLabel();
        this.block = new JFormattedTextField();
        this.jLabel12 = new JLabel();
        this.dodge = new JFormattedTextField();
        this.jLabel13 = new JLabel();
        this.dr = new JFormattedTextField();
        this.shieldPanel = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.db = new JFormattedTextField();
        this.shield_dr = new JFormattedTextField();
        this.shield_hp = new JFormattedTextField();
        this.debugPanel = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.shieldDamageLabel = new JLabel();
        this.numParryLabel = new JLabel();
        this.numBlockLabel = new JLabel();
        this.jFormattedTextField1.setText("jFormattedTextField1");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jLabel2.setText("Status:");
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setText("Type:");
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setText("HT/HP:");
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setText("Damage:");
        this.attacks.setBorder(BorderFactory.createTitledBorder("Attacks"));
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.add_attack.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/add.png")));
        this.add_attack.setFocusable(false);
        this.add_attack.setHorizontalTextPosition(0);
        this.add_attack.setIconTextGap(1);
        this.add_attack.setVerticalTextPosition(3);
        this.add_attack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.add_attackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.add_attack);
        this.remove_attack.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/delete.png")));
        this.remove_attack.setFocusable(false);
        this.remove_attack.setHorizontalTextPosition(0);
        this.remove_attack.setVerticalTextPosition(3);
        this.remove_attack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.remove_attackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.remove_attack);
        this.default_attack.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/wrench_orange.png")));
        this.default_attack.setFocusable(false);
        this.default_attack.setHorizontalTextPosition(0);
        this.default_attack.setVerticalTextPosition(3);
        this.default_attack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.default_attackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.default_attack);
        this.jToolBar1.add(this.jSeparator2);
        this.resizeAttackTable.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/script_code.png")));
        this.resizeAttackTable.setFocusable(false);
        this.resizeAttackTable.setHorizontalTextPosition(0);
        this.resizeAttackTable.setVerticalTextPosition(3);
        this.resizeAttackTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.resizeAttackTableActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.resizeAttackTable);
        this.attacksTable.setAutoCreateRowSorter(true);
        this.attacksTable.setModel(this.attackTableModel);
        this.attacksTable.setAutoscrolls(false);
        this.attacksTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.attacksTable);
        GroupLayout attacksLayout = new GroupLayout(this.attacks);
        this.attacks.setLayout(attacksLayout);
        attacksLayout.setHorizontalGroup(attacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE));
        attacksLayout.setVerticalGroup(attacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attacksLayout.createSequentialGroup().addComponent(this.jToolBar1, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.status.setModel(new DefaultComboBoxModel<Actor.ActorState>(Actor.ActorState.values()));
        this.status.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.statusActionPerformed(evt);
            }
        });
        this.status.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.type.setModel(new DefaultComboBoxModel<Actor.ActorType>(Actor.ActorType.values()));
        this.type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActorDetailsPanel.this.typeActionPerformed(evt);
            }
        });
        this.type.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.jLabel7.setFont(this.jLabel7.getFont().deriveFont(this.jLabel7.getFont().getStyle() | 1));
        this.jLabel7.setText("FP:");
        this.hp.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.hp.setText("99");
        this.hp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.hp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.hpPropertyChange(evt);
            }
        });
        this.damage.setForeground(new Color(220, 0, 0));
        this.damage.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.damage.setText("99");
        this.damage.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.damage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.damagePropertyChange(evt);
            }
        });
        this.ht.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.ht.setText("99");
        this.ht.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.ht.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.htPropertyChange(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText("Notes:");
        this.jScrollPane1.setPreferredSize(new Dimension(50, 50));
        this.jScrollPane1.setRequestFocusEnabled(false);
        this.notes.setFont(new Font("Tahoma", 0, 11));
        this.notes.setRows(5);
        this.jScrollPane1.setViewportView(this.notes);
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Move:");
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Dodge");
        this.fp.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.fp.setText("99");
        this.fp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.fp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.fpPropertyChange(evt);
            }
        });
        this.move.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.move.setText("99");
        this.move.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.move.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.movePropertyChange(evt);
            }
        });
        this.fatigue.setForeground(new Color(220, 0, 0));
        this.fatigue.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.fatigue.setText("99");
        this.fatigue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.fatigue.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.fatiguePropertyChange(evt);
            }
        });
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jLabel6.setText("Fatigue:");
        this.parry.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.parry.setText("99");
        this.parry.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.parry.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.parryPropertyChange(evt);
            }
        });
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setFont(new Font("Tahoma", 1, 20));
        this.name.setText("name");
        this.name.setBorder(null);
        this.name.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ActorDetailsPanel.this.nameFocusLost(evt);
            }
        });
        this.name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ActorDetailsPanel.this.nameKeyTyped(evt);
            }
        });
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setText("Parry");
        this.block.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.block.setText("99");
        this.block.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.block.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.blockPropertyChange(evt);
            }
        });
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setText("Block");
        this.dodge.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.dodge.setText("99");
        this.dodge.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.dodge.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.dodgePropertyChange(evt);
            }
        });
        this.jLabel13.setFont(new Font("Tahoma", 1, 11));
        this.jLabel13.setText("DR:");
        this.dr.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.dr.setText("99");
        this.dr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.dr.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.drPropertyChange(evt);
            }
        });
        this.shieldPanel.setBorder(BorderFactory.createTitledBorder("Shield"));
        this.shieldPanel.setCursor(new Cursor(0));
        this.jLabel15.setFont(new Font("Tahoma", 1, 11));
        this.jLabel15.setText("DB");
        this.jLabel16.setFont(new Font("Tahoma", 1, 11));
        this.jLabel16.setText("DR");
        this.jLabel17.setFont(new Font("Tahoma", 1, 11));
        this.jLabel17.setText("HP");
        this.db.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.db.setText("99");
        this.db.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.db.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.dbPropertyChange(evt);
            }
        });
        this.shield_dr.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.shield_dr.setText("99");
        this.shield_dr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.shield_dr.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.shield_drPropertyChange(evt);
            }
        });
        this.shield_hp.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.shield_hp.setText("99");
        this.shield_hp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ActorDetailsPanel.this.fieldFocusGained(evt);
            }
        });
        this.shield_hp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActorDetailsPanel.this.shield_hpPropertyChange(evt);
            }
        });
        GroupLayout shieldPanelLayout = new GroupLayout(this.shieldPanel);
        this.shieldPanel.setLayout(shieldPanelLayout);
        shieldPanelLayout.setHorizontalGroup(shieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(shieldPanelLayout.createSequentialGroup().addComponent(this.jLabel15, -2, 45, -2).addGap(10, 10, 10).addComponent(this.jLabel16, -2, 45, -2).addGap(10, 10, 10).addComponent(this.jLabel17, -2, 45, -2)).addGroup(shieldPanelLayout.createSequentialGroup().addComponent(this.db, -2, 45, -2).addGap(10, 10, 10).addComponent(this.shield_dr, -2, 45, -2).addGap(10, 10, 10).addComponent(this.shield_hp, -2, 45, -2)));
        shieldPanelLayout.setVerticalGroup(shieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(shieldPanelLayout.createSequentialGroup().addGroup(shieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 20, -2).addComponent(this.jLabel16, -2, 20, -2).addComponent(this.jLabel17, -2, 20, -2)).addGroup(shieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.db, -2, -1, -2).addComponent(this.shield_dr, -2, -1, -2).addComponent(this.shield_hp, -2, -1, -2))));
        this.debugPanel.setBorder(BorderFactory.createTitledBorder("Debug"));
        this.debugPanel.setCursor(new Cursor(0));
        this.jLabel18.setFont(new Font("Tahoma", 1, 11));
        this.jLabel18.setText("Shield Damage:");
        this.jLabel19.setFont(new Font("Tahoma", 1, 11));
        this.jLabel19.setText("numParry:");
        this.jLabel20.setFont(new Font("Tahoma", 1, 11));
        this.jLabel20.setText("numBlock:");
        this.shieldDamageLabel.setText("asdf");
        this.numParryLabel.setText("asdf");
        this.numBlockLabel.setText("asdf");
        GroupLayout debugPanelLayout = new GroupLayout(this.debugPanel);
        this.debugPanel.setLayout(debugPanelLayout);
        debugPanelLayout.setHorizontalGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugPanelLayout.createSequentialGroup().addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugPanelLayout.createSequentialGroup().addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel20, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numParryLabel, -2, 51, -2).addComponent(this.numBlockLabel, -2, 51, -2))).addGroup(debugPanelLayout.createSequentialGroup().addComponent(this.jLabel18, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shieldDamageLabel, -2, 39, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        debugPanelLayout.setVerticalGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugPanelLayout.createSequentialGroup().addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.shieldDamageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numParryLabel).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(debugPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.numBlockLabel))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, GroupLayout.Alignment.TRAILING).addComponent(this.attacks, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.parry, -2, 41, -2))).addComponent(this.jLabel13, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -2, 52, -2).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 53, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.type, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.status, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addGap(18, 18, 18).addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.damage).addComponent(this.move).addComponent(this.fatigue).addComponent(this.fp).addComponent(this.ht, -1, 41, Short.MAX_VALUE).addComponent(this.block, -1, 41, Short.MAX_VALUE).addComponent(this.dr, -1, 41, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.dodge, -1, 41, Short.MAX_VALUE).addComponent(this.hp)))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.shieldPanel, -1, -1, Short.MAX_VALUE).addComponent(this.debugPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.name, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.status, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.type, -2, -1, -2).addComponent(this.jLabel3)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ht, -2, -1, -2).addComponent(this.jLabel4, -2, 17, -2).addComponent(this.hp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.damage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.fp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fatigue, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.move, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.block, -2, -1, -2).addComponent(this.parry, -2, -1, -2).addComponent(this.dodge, -2, -1, -2)).addComponent(this.jSeparator1, -2, 9, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.dr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shieldPanel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.attacks, -2, -1, -2).addGap(1, 1, 1).addComponent(this.debugPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 35, Short.MAX_VALUE)));
    }

    private void htPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.HT.ordinal(), ((Long)this.ht.getValue()).intValue());
        }
    }

    private void hpPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.HP.ordinal(), ((Long)this.hp.getValue()).intValue());
        }
    }

    private void damagePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Damage.ordinal(), ((Long)this.damage.getValue()).intValue());
        }
    }

    private void fpPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.FP.ordinal(), ((Long)this.fp.getValue()).intValue());
        }
    }

    private void fatiguePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Fatigue.ordinal(), ((Long)this.fatigue.getValue()).intValue());
        }
    }

    private void movePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Move.ordinal(), ((Long)this.move.getValue()).intValue());
        }
    }

    private void dodgePropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.setActorValue(InitTableModel.columns.Dodge.ordinal(), ((Long)this.dodge.getValue()).intValue());
        }
    }

    private void parryPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).Parry = ((Long)this.parry.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void blockPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).Block = ((Long)this.block.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void drPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).DR = ((Long)this.dr.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void dbPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).DB = ((Long)this.db.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void shield_drPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).ShieldDR = ((Long)this.shield_dr.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void shield_hpPropertyChange(PropertyChangeEvent evt) {
        if (this.actorLoaded && evt.getPropertyName().equals("value")) {
            this.actorModel.getActor((int)this.selectedActor).ShieldHP = ((Long)this.shield_hp.getValue()).intValue();
            this.actorModel.setDirty();
        }
    }

    private void statusActionPerformed(ActionEvent evt) {
        if (this.actorLoaded) {
            this.setActorValue(InitTableModel.columns.State.ordinal(), ((JComboBox)evt.getSource()).getSelectedItem().toString());
        }
    }

    private void typeActionPerformed(ActionEvent evt) {
        if (this.actorLoaded) {
            this.setActorValue(InitTableModel.columns.Type.ordinal(), ((JComboBox)evt.getSource()).getSelectedItem().toString());
            this.refreshActor();
        }
    }

    private void fieldFocusGained(FocusEvent evt) {
        this.initTable.stopCellEditing();
        Component com = evt.getComponent();
        if (JFormattedTextField.class.equals(com.getClass())) {
            JFormattedTextField t = (JFormattedTextField)evt.getComponent();
            t.setText(t.getText());
            t.selectAll();
        } else if (JComboBox.class.equals(com.getClass()) || JTextField.class.equals(com.getClass()) || JTextArea.class.equals(com.getClass())) {
            // empty if block
        }
    }

    private void nameKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c == '\u001b') {
            this.name.setText(this.actorModel.getActor((int)this.selectedActor).Name);
        } else if (c == '\n') {
            this.setActorValue(InitTableModel.columns.Name.ordinal(), this.name.getText());
        }
    }

    private void nameFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            this.setActorValue(InitTableModel.columns.Name.ordinal(), this.name.getText());
        }
    }

    private void add_attackActionPerformed(ActionEvent evt) {
        this.attackTableModel.addAttack();
        this.resizeAttacksTable();
        this.actorModel.setDirty();
    }

    private void remove_attackActionPerformed(ActionEvent evt) {
        int[] viewRows = this.attacksTable.getSelectedRows();
        int[] modelRows = new int[viewRows.length];
        int i = 0;
        while (i < viewRows.length) {
            modelRows[i] = this.attacksTable.getRowSorter().convertRowIndexToModel(viewRows[i]);
            ++i;
        }
        Arrays.sort(modelRows);
        this.attackTableModel.removeAttacks(modelRows);
        this.resizeAttacksTable();
        this.actorModel.setDirty();
    }

    private void default_attackActionPerformed(ActionEvent evt) {
        int modelRow = this.attacksTable.getRowSorter().convertRowIndexToModel(this.attacksTable.getSelectedRow());
        this.attackTableModel.setDefaultAttack(modelRow);
        this.resizeAttacksTable();
    }

    private void resizeAttackTableActionPerformed(ActionEvent evt) {
        this.resizeAttacksTable();
    }

    public void disablePanel() {
        this.ht.setValue(10);
        this.ht.setEnabled(false);
        this.hp.setValue(10);
        this.hp.setEnabled(false);
        this.damage.setValue(0);
        this.damage.setEnabled(false);
        this.fp.setValue(10);
        this.fp.setEnabled(false);
        this.fatigue.setValue(0);
        this.fatigue.setEnabled(false);
        this.move.setValue(5);
        this.move.setEnabled(false);
        this.parry.setValue(9);
        this.parry.setEnabled(false);
        this.block.setValue(9);
        this.block.setEnabled(false);
        this.dodge.setValue(8);
        this.dodge.setEnabled(false);
        this.dr.setValue(0);
        this.dr.setEnabled(false);
        this.db.setValue(2);
        this.db.setEnabled(false);
        this.shield_dr.setValue(4);
        this.shield_dr.setEnabled(false);
        this.shield_hp.setValue(20);
        this.shield_hp.setEnabled(false);
        this.status.setSelectedIndex(0);
        this.status.setEnabled(false);
        this.type.setSelectedIndex(0);
        this.type.setEnabled(false);
        this.name.setText("");
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setEnabled(false);
        this.add_attack.setEnabled(false);
        this.remove_attack.setEnabled(false);
        this.default_attack.setEnabled(false);
        this.resizeAttackTable.setEnabled(false);
        this.attackTableModel.setActor(null);
        this.resizeAttacksTable();
        this.notes.setText("");
        this.notes.setEnabled(false);
    }

    private void enablePanel() {
        this.ht.setEnabled(true);
        this.hp.setEnabled(true);
        this.damage.setEnabled(true);
        this.fp.setEnabled(true);
        this.fatigue.setEnabled(true);
        this.move.setEnabled(true);
        this.parry.setEnabled(true);
        this.block.setEnabled(true);
        this.dodge.setEnabled(true);
        this.dr.setEnabled(true);
        this.db.setEnabled(true);
        this.shield_dr.setEnabled(true);
        this.shield_hp.setEnabled(true);
        this.status.setEnabled(true);
        this.type.setEnabled(true);
        this.name.setEnabled(true);
        this.add_attack.setEnabled(true);
        this.remove_attack.setEnabled(true);
        this.default_attack.setEnabled(true);
        this.resizeAttackTable.setEnabled(true);
        this.notes.setEnabled(true);
    }

    public void resizeAttacksTable() {
        this.attacks.setPreferredSize(new Dimension(0, this.attacks.getMinimumSize().height + this.attacksTable.getRowHeight() * this.attackTableModel.getRowCount()));
        TableColumn column = null;
        int i = 0;
        while (i < this.attacksTable.getColumnCount()) {
            column = this.attacksTable.getColumnModel().getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.attacksTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.attacksTable, column.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int j = 0;
            while (j < this.attacksTable.getRowCount()) {
                renderer = this.attacksTable.getCellRenderer(j, i);
                comp = renderer.getTableCellRendererComponent(this.attacksTable, this.attacksTable.getValueAt(j, i), false, false, j, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++j;
            }
            column.setPreferredWidth(width);
            ++i;
        }
        this.attacks.revalidate();
    }

    public void refreshActor() {
        this.actorLoaded = false;
        if (this.initTable.getSelectedRow() == -1) {
            this.disablePanel();
            return;
        }
        this.enablePanel();
        this.selectedActor = this.initTable.getSelectedRow();
        Actor actor = this.actorModel.getActor(this.initTable.getSelectedRow());
        this.name.setText(actor.Name);
        switch (actor.Type) {
            case PC: {
                this.name.setBackground(new Color(200, 255, 200));
                break;
            }
            case Ally: {
                this.name.setBackground(new Color(200, 200, 255));
                break;
            }
            case Enemy: {
                this.name.setBackground(new Color(255, 200, 200));
                break;
            }
            case Neutral: {
                this.name.setBackground(new Color(200, 200, 200));
                break;
            }
            case Special: {
                this.name.setBackground(new Color(255, 200, 255));
            }
        }
        this.name.setForeground(new Color(0, 0, 0));
        switch (actor.State) {
            case Waiting: {
                break;
            }
            case Unconscious: 
            case Dead: {
                this.name.setForeground(new Color(128, 128, 128));
            }
        }
        this.status.setSelectedItem((Object)actor.State);
        this.type.setSelectedItem((Object)actor.Type);
        this.ht.setValue(Integer.valueOf(actor.HT).longValue());
        this.hp.setValue(Integer.valueOf(actor.HP).longValue());
        this.damage.setValue(Integer.valueOf(actor.Injury).longValue());
        this.fp.setValue(Integer.valueOf(actor.FP).longValue());
        this.fatigue.setValue(Integer.valueOf(actor.Fatigue).longValue());
        this.move.setValue(Integer.valueOf(actor.Move).longValue());
        this.parry.setValue(Integer.valueOf(actor.Parry).longValue());
        this.block.setValue(Integer.valueOf(actor.Block).longValue());
        this.dodge.setValue(Integer.valueOf(actor.Dodge).longValue());
        this.dr.setValue(Integer.valueOf(actor.DR).longValue());
        this.db.setValue(Integer.valueOf(actor.DB).longValue());
        this.shield_dr.setValue(Integer.valueOf(actor.ShieldDR).longValue());
        this.shield_hp.setValue(Integer.valueOf(actor.ShieldHP).longValue());
        this.notes.setText(actor.Notes);
        this.attackTableModel.setActor(actor);
        this.shieldDamageLabel.setText(String.valueOf(actor.ShieldDamage));
        this.numParryLabel.setText(String.valueOf(actor.numParry));
        this.numBlockLabel.setText(String.valueOf(actor.numBlock));
        this.resizeAttacksTable();
        this.actorLoaded = true;
    }

    protected void setActorValue(int column, Object value) {
        this.actorLoaded = false;
        this.actorModel.setValueAt(value, this.selectedActor, column);
        this.actorLoaded = true;
    }

    public void setActorModel(InitTableModel model) {
        if (this.actorModel != null) {
            this.actorModel.removeTableModelListener(this);
        }
        if (model != null) {
            model.addTableModelListener(this);
        }
        this.actorModel = model;
        this.refreshActor();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.actorLoaded) {
            this.refreshActor();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.refreshActor();
        }
    }

    protected class ActorTextDocumentListener
    implements DocumentListener {
        private textListenField lField;

        public ActorTextDocumentListener(textListenField field) {
            this.lField = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processTextChanges(e);
        }

        private void processTextChanges(DocumentEvent e) {
            if (ActorDetailsPanel.this.actorLoaded) {
                Document document = e.getDocument();
                try {
                    switch (this.lField) {
                        case Name: {
                            ActorDetailsPanel.this.setActorValue(InitTableModel.columns.Name.ordinal(), document.getText(0, document.getLength()));
                            break;
                        }
                        case Notes: {
                            ((ActorDetailsPanel)ActorDetailsPanel.this).actorModel.getActor((int)((ActorDetailsPanel)ActorDetailsPanel.this).selectedActor).Notes = document.getText(0, document.getLength());
                            ActorDetailsPanel.this.actorModel.setDirty();
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    protected static enum textListenField {
        Name,
        Notes;

    }
}

