/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.data.CriticalTables;
import gurpsinittool.util.DieRoller;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CriticalTablesDialog
extends JDialog {
    private JTable headTable;
    private JTable hitTable;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTabbedPane jTabbedPane;
    private JTable missTable;
    private JButton rollButton;
    private JLabel rollLabel;
    private JPanel statusPanel;
    private JTable unarmedTable;

    public CriticalTablesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initCritTable(this.hitTable, CriticalTables.critical_hit);
        this.initCritTable(this.missTable, CriticalTables.critical_miss);
        this.initCritTable(this.headTable, CriticalTables.critical_head_hit);
        this.initCritTable(this.unarmedTable, CriticalTables.critical_miss_unarmed);
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.rollLabel = new JLabel();
        this.rollButton = new JButton();
        this.jTabbedPane = new JTabbedPane();
        this.jScrollPane5 = new JScrollPane();
        this.hitTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.headTable = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.missTable = new JTable();
        this.jScrollPane4 = new JScrollPane();
        this.unarmedTable = new JTable();
        this.setName("CriticalTableDialog");
        this.setType(Window.Type.UTILITY);
        this.statusPanel.setBorder(new SoftBevelBorder(0));
        this.rollLabel.setText("Roll:");
        this.rollButton.setText("Roll");
        this.rollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CriticalTablesDialog.this.rollButtonActionPerformed(evt);
            }
        });
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.rollLabel, -1, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rollButton)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rollLabel).addComponent(this.rollButton)));
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.hitTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Roll", "Entry"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[2];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane5.setViewportView(this.hitTable);
        this.jTabbedPane.addTab("Critical Hit", this.jScrollPane5);
        this.headTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Roll", "Entry"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[2];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.headTable);
        this.jTabbedPane.addTab("Critical Head Blow", this.jScrollPane2);
        this.missTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Roll", "Entry"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[2];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.missTable);
        this.jTabbedPane.addTab("Critical Miss", this.jScrollPane3);
        this.unarmedTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Roll", "Entry"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[2];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane4.setViewportView(this.unarmedTable);
        this.jTabbedPane.addTab("Unarmed Critical Miss", this.jScrollPane4);
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.pack();
    }

    private void rollButtonActionPerformed(ActionEvent evt) {
        int result = DieRoller.roll3d6();
        this.rollLabel.setText("Roll: " + result);
        JScrollPane pane = (JScrollPane)this.jTabbedPane.getSelectedComponent();
        JTable current_table = (JTable)pane.getViewport().getView();
        ArrayList current_data = (ArrayList)current_table.getClientProperty(0);
        int i = 0;
        while (i < current_data.size()) {
            int j = 0;
            while (j < ((CriticalTables.Entry)current_data.get((int)i)).rolls.size()) {
                if (((CriticalTables.Entry)current_data.get((int)i)).rolls.get(j) == result) {
                    current_table.getSelectionModel().setSelectionInterval(i, i);
                    current_table.scrollRectToVisible(current_table.getCellRect(i, 0, true));
                }
                ++j;
            }
            ++i;
        }
    }

    private void initCritTable(JTable table, ArrayList<CriticalTables.Entry> data) {
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        table.putClientProperty(0, data);
        int i = 0;
        while (i < data.size()) {
            String numbers = "";
            CriticalTables.Entry entry = data.get(i);
            int j = 0;
            while (j < entry.rolls.size()) {
                if (j > 0) {
                    numbers = String.valueOf(numbers) + ", ";
                }
                numbers = String.valueOf(numbers) + entry.rolls.get(j);
                ++j;
            }
            tableModel.addRow(new Object[]{numbers, entry.notes});
            ++i;
        }
        table.revalidate();
        TableColumn column = table.getColumnModel().getColumn(0);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        int j = 0;
        while (j < table.getRowCount()) {
            renderer = table.getCellRenderer(j, 0);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(j, 0), false, false, j, 0);
            width = Math.max(width, comp.getPreferredSize().width);
            ++j;
        }
        table.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(width);
        table.setDefaultRenderer(String.class, new MultiLineTableCellRenderer());
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CriticalTablesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CriticalTablesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CriticalTablesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CriticalTablesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CriticalTablesDialog dialog = new CriticalTablesDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class MultiLineTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();

        public MultiLineTableCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
            }
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.adjustRowHeight(table, row, column);
            return this;
        }

        private void adjustRowHeight(JTable table, int row, int column) {
            int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
            this.setSize(new Dimension(cWidth, 1000));
            int prefH = this.getPreferredSize().height;
            while (this.rowColHeight.size() <= row) {
                this.rowColHeight.add(new ArrayList(column));
            }
            List<Integer> colHeights = this.rowColHeight.get(row);
            while (colHeights.size() <= column) {
                colHeights.add(0);
            }
            colHeights.set(column, prefH);
            int maxH = prefH;
            for (Integer colHeight : colHeights) {
                if (colHeight <= maxH) continue;
                maxH = colHeight;
            }
            if (table.getRowHeight(row) != maxH) {
                table.setRowHeight(row, maxH);
            }
        }
    }
}

